<?php

namespace boru\ocr\Layout\Support;

class RegionGeometry
{
    public static function area(array $r)
    {
        $w = (int)$r['maxRight'] - (int)$r['minLeft'];
        $h = (int)$r['maxBottom'] - (int)$r['minTop'];
        $a = $w * $h;
        return ($a > 0) ? $a : 1;
    }

    /**
     * intersection_area / area(inner)
     */
    public static function containmentRatio(array $inner, array $outer)
    {
        $ix = max(0, min((int)$inner['maxRight'], (int)$outer['maxRight']) - max((int)$inner['minLeft'], (int)$outer['minLeft']));
        $iy = max(0, min((int)$inner['maxBottom'], (int)$outer['maxBottom']) - max((int)$inner['minTop'], (int)$outer['minTop']));
        $inter = $ix * $iy;

        $areaInner = self::area($inner);
        return $inter / $areaInner;
    }

    /**
     * Vertical overlap of a and b as overlap / min(height(a), height(b))
     */
    public static function verticalOverlapRatio(array $a, array $b)
    {
        $iy = max(
            0,
            min((int)$a['maxBottom'], (int)$b['maxBottom']) - max((int)$a['minTop'], (int)$b['minTop'])
        );

        $ha = max(1, (int)$a['maxBottom'] - (int)$a['minTop']);
        $hb = max(1, (int)$b['maxBottom'] - (int)$b['minTop']);

        return $iy / min($ha, $hb);
    }

    public static function cmpRegionAreaDesc($a, $b)
    {
        $aa = self::area($a);
        $bb = self::area($b);
        if ($aa === $bb) return 0;
        return ($aa > $bb) ? -1 : 1;
    }
}
