<?php
namespace boru\ocr\Agent;

use boru\ocr\Traits\OcrLogTrait;

class AiOptions {
    /** @var AgentOptions */
    public $plannerOptions;
    /** @var AgentOptions */
    public $tableInterpreterOptions;
    /** @var AgentOptions */
    public $finalAgentOptions;

    public $userTableInterpreter = true;
    public $usePlanner = true;

    /** @var OCRLogger|null */
    protected $logger;
    use OcrLogTrait;

    public function __construct($options=null) {
        $this->plannerOptions = new AgentOptions();
        $this->tableInterpreterOptions = new AgentOptions();
        $this->finalAgentOptions = new AgentOptions();
        if (is_array($options)) {
            $this->setOptionsFromArray($options);
        }
    }

    public function setOptionsFromArray(array $options) {
        foreach ($options as $key => $value) {
            if (property_exists($this, $key)) {
                $this->$key = $value;
            }
        }
    }

    public function setPlannerOption($key, $value) {
        $this->plannerOptions->set($key, $value);
    }

    public function setTableInterpreterOption($key, $value) {
        $this->tableInterpreterOptions->set($key, $value);
    }

    public function setFinalAgentOption($key, $value) {
        $this->finalAgentOptions->set($key, $value);
    }

    public static function fromArray(array $options) {
        $aiOptions = new self();
        $aiOptions->setOptionsFromArray($options);
        return $aiOptions;
    }

    public static function create($input=null) {
        if($input instanceof self) {
            return $input;
        } elseif(is_array($input)) {
            return self::fromArray($input);
        } else {
            return new self();
        }
    }
}