<?php

namespace boru\ocr\Confidence;

class PageConfidence
{
    /** @var int */
    public $page = 0;

    /** @var int */
    public $tokenCount = 0;

    /** @var int */
    public $confCount = 0;

    /** @var float|null */
    public $confAvg = null;

    /** @var int|null */
    public $confMin = null;

    /** @var int|null */
    public $confMax = null;

    /** @var array */
    public $percentiles = array(); // p10/p25/p50/p75/p90

    /** @var float */
    public $lowConfRatio = 0.0;

    /** @var float */
    public $veryLowConfRatio = 0.0;

    public function toArray()
    {
        return array(
            'page' => $this->page,
            'tokenCount' => $this->tokenCount,
            'confCount' => $this->confCount,
            'confAvg' => $this->confAvg,
            'confMin' => $this->confMin,
            'confMax' => $this->confMax,
            'percentiles' => $this->percentiles,
            'lowConfRatio' => $this->lowConfRatio,
            'veryLowConfRatio' => $this->veryLowConfRatio,
        );
    }
}
