<?php

namespace boru\ocr\Layout\Support;

use boru\ocr\Layout\LayoutOptions;
use boru\ocr\Tesseract\Tsv\TsvRow;

class LineRenderer
{
    /** @var bool */
    protected $dropEmpty = true;

    /** @var bool */
    protected $preserveGapSpacing = false;

    /** @var int */
    protected $gapExtraSpacePx = 12;

    public function __construct(LayoutOptions $options = null)
    {
        if ($options && isset($options->dropEmpty)) $this->dropEmpty = (bool)$options->dropEmpty;
        if ($options && isset($options->preserveGapSpacing)) $this->preserveGapSpacing = (bool)$options->preserveGapSpacing;
        if ($options && isset($options->gapExtraSpacePx)) $this->gapExtraSpacePx = (int)$options->gapExtraSpacePx;
    }

    /**
     * Render a line into readable text.
     *
     * @param TsvRow[] $line (assumed already sorted left->right)
     * @return string
     */
    public function renderLine(array $line)
    {
        $out = '';
        $prevRight = null;

        foreach ($line as $r) {
            $t = $r->text;

            if ($this->dropEmpty && $t === '') continue;

            $t = str_replace(array("\t", "\r", "\n"), ' ', $t);

            if ($out === '') {
                $out = $t;
                $prevRight = $r->right();
                continue;
            }

            $gap = 0;
            if ($prevRight !== null) {
                $gap = (int)$r->left - (int)$prevRight;
            }

            $out .= ' ';
            if ($this->preserveGapSpacing && $gap > $this->gapExtraSpacePx) {
                $out .= ' ';
            }

            $out .= $t;
            $prevRight = $r->right();
        }

        return $out;
    }
}
