<?php

namespace boru\ocr\Page;

class SingleImagePageImageProvider implements PageImageProviderInterface
{
    /** @var string */
    protected $imagePath;

    /** @var bool */
    protected $cleaned = false;

    /**
     * @param string $imagePath
     */
    public function __construct($imagePath)
    {
        if (!file_exists($imagePath)) {
            throw new \Exception("Image file not found: " . $imagePath);
        }
        $this->imagePath = $imagePath;
    }

    /**
     * Single page, no tiling.
     *
     * @return array<int,string>
     */
    public function getPages()
    {
        return array(
            0 => $this->imagePath
        );
    }

    /**
     * Nothing to cleanup.
     *
     * @return void
     */
    public function cleanup()
    {
        // no-op
        $this->cleaned = true;
    }
}
