<?php

namespace boru\ocr\Pipeline;

use boru\ocr\Tesseract\Tsv\TsvPage;
use boru\ocr\Confidence\ConfidenceReport;

class OcrResult
{
    /** @var string */
    public $sourceFile;

    /** @var ConfidenceReport|null */
    public $confidence = null;

    /** @var array<int,string> Per-page Tesseract plain text */
    public $textPages = array();

    /** @var TsvPage[] */
    public $tsvPages = array();

    /** @var array<int,string> Per-page baseline built from TSV layout */
    public $baselinePages = array();

    /** @var array<int,array> Per-page layout diagnostics (if enabled) */
    public $layoutDiagnosticsPages = array();

    /** @var array<int,array> Per-page table candidates (pages/regions) */
    public $tableCandidates = array();

    /** @var array Arbitrary metrics/stats */
    public $metrics = array();

    /** @var array Debug info (provider chosen, options used, etc.) */
    public $debug = array();

    public function __construct($sourceFile)
    {
        $this->sourceFile = (string)$sourceFile;
    }
}
