<?php

namespace boru\ocr\Source;

use boru\ocr\Page\SingleImagePageImageProvider;
use boru\ocr\Page\PageImageProviderFactory;
use boru\ocr\Source\Spreadsheet\SpreadsheetPageTextProvider;
use boru\ocr\Source\Word\WordPageTextProvider;

class SourceRouter
{
    /**
     * @param string $sourceFile
     * @param string $imageDir
     * @param array $providerOptions
     * @return array
     */
    public static function resolve($sourceFile, $imageDir, array $providerOptions = array())
    {
        $ext = strtolower(pathinfo($sourceFile, PATHINFO_EXTENSION));

        // Images
        if (in_array($ext, array('png','jpg','jpeg','tif','tiff','webp'))) {
            return array(
                'type' => 'image',
                'provider' => new SingleImagePageImageProvider($sourceFile),
            );
        }

        if (in_array($ext, array('csv','xls','xlsx'))) {
            return array(
                'type' => 'spreadsheet',
                'textProvider' => new SpreadsheetPageTextProvider($sourceFile),
            );
        }

        if (in_array($ext, array('doc','docx'))) {
            return array(
                'type' => 'word',
                'textProvider' => new WordPageTextProvider($sourceFile),
            );
        }
        
        // Default: PDF
        return array(
            'type' => 'pdf',
            'provider' => PageImageProviderFactory::createBest(
                $sourceFile,
                $imageDir,
                $providerOptions
            ),
        );
    }
}
