<?php

namespace boru\ocr\Tesseract\Tsv;

class TsvRow
{
    public $level;
    public $page_num;
    public $block_num;
    public $par_num;
    public $line_num;
    public $word_num;
    public $left;
    public $top;
    public $width;
    public $height;
    public $conf;
    public $text;

    /**
     * @param array $data Assoc by column name
     */
    public function __construct(array $data)
    {
        $this->level     = (int)$this->get($data, 'level', 0);
        $this->page_num  = (int)$this->get($data, 'page_num', 0);
        $this->block_num = (int)$this->get($data, 'block_num', 0);
        $this->par_num   = (int)$this->get($data, 'par_num', 0);
        $this->line_num  = (int)$this->get($data, 'line_num', 0);
        $this->word_num  = (int)$this->get($data, 'word_num', 0);
        $this->left      = (int)$this->get($data, 'left', 0);
        $this->top       = (int)$this->get($data, 'top', 0);
        $this->width     = (int)$this->get($data, 'width', 0);
        $this->height    = (int)$this->get($data, 'height', 0);
        $this->conf      = (float)$this->get($data, 'conf', -1);
        $this->text      = (string)$this->get($data, 'text', '');
    }

    public function right()
    {
        return $this->left + $this->width;
    }

    public function bottom()
    {
        return $this->top + $this->height;
    }

    public function isEmpty()
    {
        return $this->text === '';
    }

    /**
     * Apply tile offset (used when stitching)
     * @param int $dx
     * @param int $dy
     * @return void
     */
    public function applyOffset($dx, $dy)
    {
        $this->left += (int)$dx;
        $this->top  += (int)$dy;
    }

    private function get(array $data, $key, $default)
    {
        return array_key_exists($key, $data) ? $data[$key] : $default;
    }
}
