<?php
namespace boru\openai;

use boru\openai\api\Chat;
use boru\openai\api\responses\ApiResponse;
use Exception;

class OpenAI {
    /**
     * @var \boru\dhutils\dhHttp
     */
    private static $http;
    private static $api_key;
    private static $api_version = "v1";
    private static $api_url = "https://api.openai.com";

    private static $isInit = false;

    public static function init($api_key,$api_version="v1") {
        static::$isInit=true;
        static::setApiKey($api_key);
        static::setApiVersion($api_version);
        static::newHttp();
    }

    public static function isInit() {
        return static::$isInit;
    }
    public static function verifyInit() {
        if(!static::isInit()) {
            throw new \Exception("OpenAI is not initialized. Please call OpenAI::init(\$api_key,\$api_version) first.");
        }
    }

    public static function newHttp() {
        static::$http = new \boru\dhutils\dhHttp();
    }
    public static function setApiKey($api_key) {
        static::$api_key = $api_key;
    }
    public static function setApiVersion($api_version) {
        static::$api_version = $api_version;
    }
    public static function setApiUrl($api_url) {
        static::$api_url = $api_url;
    }

    public static function getEndpoint($path="") {
        return static::$api_url . "/" . static::$api_version . "/" . $path;
    }

    private static function authHeaders(&$req) {
        $req->header("Authorization","Bearer " . static::$api_key);
        $req->header("Content-Type","application/json");
        $req->header("Accept","application/json");
        $req->header("User-Agent","OpenAI-PHP/0.1");
        $req->header("OpenAI-Source","boru/openai-php");
    }

    /**
     * @param mixed $type 
     * @param string $path 
     * @param array $parameters 
     * @return array|ApiResponse|false 
     * @throws Exception 
     */
    public static function request($type,$path="",$parameters=[],$asArray=false) {
        static::verifyInit();
        $request = static::$http->request($type,static::getEndpoint($path));
        static::authHeaders($request);
        if(!empty($parameters) && is_array($parameters)) {
            $request->body(json_encode($parameters));
        }
        if($asArray) {
            ApiResponse::fromResponse($request->send())->asArray();
        }
        return ApiResponse::fromResponse($request->send());
    }

    /**
     * @param string $path
     * @param array $paramaters
     * @return \boru\dhutils\http\Request
     * @throws \Exception
     */
    public static function post($path="",$paramaters=[]) {
        static::verifyInit();
        $request = static::$http->request("post",static::getEndpoint($path));
        static::authHeaders($request);
        if(!empty($paramaters) && is_array($paramaters)) {
            $request->body(json_encode($paramaters));
        }
        return $request;
    }

    /**
     * @param string $path
     * @param array $paramaters
     * @return \boru\dhutils\http\Request
     * @throws \Exception
     */
    public static function get($path="",$paramaters=[]) {
        static::verifyInit();
        $request = static::$http->request("get",static::getEndpoint($path));
        static::authHeaders($request);
        if(!empty($paramaters) && is_array($paramaters)) {
            $request->body(json_encode($paramaters));
        }
        return $request;
    }

    /**
     * @param string $path
     * @param array $paramaters
     * @return \boru\dhutils\http\Request
     * @throws \Exception
     */
    public static function put($path="",$paramaters=[]) {
        static::verifyInit();
        $request = static::$http->request("put",static::getEndpoint($path));
        static::authHeaders($request);
        if(!empty($paramaters) && is_array($paramaters)) {
            $request->body(json_encode($paramaters));
        }
        return $request;
    }

    /**
     * @param string $path
     * @param array $paramaters
     * @return \boru\dhutils\http\Request
     * @throws \Exception
     */
    public static function delete($path="",$paramaters=[]) {
        static::verifyInit();
        $request = static::$http->request("delete",static::getEndpoint($path));
        static::authHeaders($request);
        if(!empty($paramaters) && is_array($paramaters)) {
            $request->body(json_encode($paramaters));
        }
        return $request;
    }


    //Convinience functions
    public static function listModels() {
        return static::request("get","models");
    }
    public static function getModel($model_id) {
        return static::request("get","models/" . $model_id);
    }
    public static function chat($options=[]) {
        $chat = Chat::fromArray($options);
        return $chat->send();
    }
}