<?php
namespace boru\openai\api\responses;

use boru\dhutils\traits\GetSetArray;

class ApiResponse implements \JsonSerializable, \ArrayAccess {
    use GetSetArray;
    /**
     * @var \boru\dhutils\http\Response
     */
    protected $response;

    protected $body = [];

    /**
     * @param \boru\dhutils\http\Response $response
     */
    public function __construct($response) {
        $this->setGetSetMainArray("body");
        $this->response = $response;
        $this->body = $response->body(true);
    }

    public function asArray() {
        return $this->body;
    }

    public function __set($field,$val) {
        $this->set($field,$val);
    }

    /**
     * @param \boru\dhutils\http\Response $response
     */
    public static function fromResponse($resp) {
        if($resp instanceof \boru\dhutils\http\Response) {
            return new self($resp);
        }
        return false;
    }

    /**
     * Inherits trait functions from GetSetArray
     * ->get($key,$default=null)
     * ->set($key,$val='',$append=false)
     * ->exists($key=null)
     */

     public function jsonSerialize($array=null) {
        if(is_null($array)) {
            $array = $this->body;
        }
        return $array;
    }

    /**
     * Ignore intelephense error, php 5.6 :(
     */
    public function offsetExists($offset) {
        return $this->exists($offset);
    }

    /**
     * Ignore intelephense error, php 5.6 :(
     */
    public function offsetGet($offset) {
        return $this->get($offset);
    }

    /**
     * Ignore intelephense error, php 5.6 :(
     */
    public function offsetSet($offset , $value) {
        $this->set($offset,$value);
    }

    /**
     * Ignore intelephense error, php 5.6 :(
     */
    public function offsetUnset($offset) {
        $this->remove($this->$offset);
    }

    public function __toString() {
        return json_encode($this);
    }
}