<?php
namespace boru\openai\api\endpoints;

use boru\openai\api\responses\ApiBaseResponse;
use boru\openai\OpenAI;

class Files {
    public static function listFiles($parameters=[]) {
        return OpenAI::request("get","files",$parameters);
    }

    public static function upload($parameters=[]) {
        return OpenAI::upload("files",$parameters);
    }

    public static function delete($file_id) {
        return OpenAI::request("delete","files/".$file_id);
    }

    public static function get($file_id) {
        return OpenAI::request("get","files/".$file_id);
    }

    public static function content($file_id) {
        return OpenAI::request("get","files/".$file_id."/content");
    }
}