<?php
namespace boru\openai\api\endpoints;

use boru\openai\models\Run;
use boru\openai\OpenAI;

class Runs {
    public static function create($threadId,$parameters=[]) {
        return new Run(OpenAI::request("post","threads/".$threadId."/runs",$parameters));
    }
    public static function listRuns($threadId) {
        return OpenAI::requestList("get","threads/".$threadId."/runs",[],Run::class);
    }
    public static function getRun($threadId,$runId) {
        return new Run(OpenAI::request("get","threads/".$threadId."/runs/".$runId));
    }
    public static function update($threadId,$runId,$parameters=[]) {
        return new Run(OpenAI::request("post","threads/".$threadId."/runs/".$runId,$parameters));
    }
    
}