<?php
namespace boru\openai\api\responses;

use boru\dhttp\core\Response;

class ApiListResponse extends ApiBaseResponse implements \Iterator {
    private $className;
    private $firstId;
    private $lastId;
    private $hasMore = false;
    private $requestCallable;
    private $requestParams;
    private $dataObjects = [];
    private $index = 0;
    /**
     * @param \boru\dhutils\http\Response $response
     */
    public function __construct($response,$className,$requestCallable,$requestParams=[]) {
        $this->className = $className;
        $this->requestCallable = $requestCallable;
        $this->requestParams = $requestParams;
        parent::__construct($response);
        $this->hasMore = $this->body["has_more"] ? true : false;
        $this->firstId = $this->body["first_id"];
        $this->lastId = $this->body["last_id"];
        $this->dataObjects = $this->body["data"];
    }

    /**
     * @param Response $response
     */
    public static function fromListResponse($resp,$className,$requestCallable,$requestParams=[]) {
        if($resp instanceof Response) {
            return new self($resp,$className,$requestCallable,$requestParams);
        }
        return false;
    }

    public function current() {
        if(isset($this->dataObjects[$this->index])) {
            $cn = $this->className;
            return new $cn($this->dataObjects[$this->index]);
        }
        return false;
    }

    public function next(): void {
        $this->index++;
    }

    public function key(): int {
        return $this->index;
    }

    public function valid(): bool {
        $valid = isset($this->dataObjects[$this->index]);
        if(!$valid && $this->hasMore) {
            $valid = $this->nextPage();
        }
        return $valid;
    }

    public function rewind(): void {
        $this->index = 0;
    }

    public function nextPage() {
        if($this->hasMore) {
            $this->requestParams[2]["after"] = $this->lastId;
            $response = call_user_func_array($this->requestCallable,$this->requestParams);
            $body = $response->body(true);
            $this->hasMore = $body["has_more"] ? true : false;
            $this->firstId = $body["first_id"];
            $this->lastId = $body["last_id"];
            foreach($body["data"] as $data) {
                $this->dataObjects[] = $data;
            }
            return true;
        }
        return false;
    }
}