<?php
namespace boru\openai\api\responses;

class AssistantResponse  implements \Iterator {
    /** @var \boru\openai\api\responses\parts\Message[] */
    private $messageParts = [];
    private $index = 0;
    public function __construct($resultArray=[]) {
        foreach($resultArray as $message) {
            $this->messageParts[] = new \boru\openai\api\responses\parts\Message($message);
        }
    }

    public function value() {
        $value = "";
        foreach($this->messageParts as $message) {
            $value .= $message->value();
        }
        return $value;
    }

    public function current() {
        if(isset($this->messageParts[$this->index])) {
            return $this->messageParts[$this->index];
        }
        return false;
    }

    public function next(): void {
        $this->index++;
    }

    public function key(): int {
        return $this->index;
    }

    public function valid(): bool {
        return isset($this->messageParts[$this->index]);
    }

    public function rewind(): void {
        $this->index = 0;
    }
}