<?php
namespace boru\openai\models;

use boru\openai\api\endpoints\Assistants;
use boru\openai\api\endpoints\Threads;
use boru\openai\api\responses\AssistantResponse;
use Exception;

class Assistant extends Base {
    /** @var string */
    private $id;
    /** @var string */
    private $object = "assistant";
    /** @var int */
    private $createdAt;
    /** @var string|null */
    private $name;
    /** @var string|null */
    private $description;
    /** @var string */
    private $model;
    /** @var string|null */
    private $instructions;
    /** @var array */
    private $tools;
    /** @var array */
    private $fileIds;
    /** @var array */
    private $metadata;


    /** @var Thread */
    private $thread;

    public function id($id=null) {
        if ($id) {
            $this->id = $id;
        }
        return $this->id;
    }
    public function object($object=null) {
        if ($object) {
            $this->object = $object;
        }
        return $this->object;
    }
    public function createdAt($created=null) {
        if ($created) {
            $this->createdAt = $created;
        }
        return $this->createdAt;
    }
    public function name($name=null) {
        if ($name) {
            $this->name = $name;
        }
        return $this->name;
    }
    public function description($description=null) {
        if ($description) {
            $this->description = $description;
        }
        return $this->description;
    }
    public function model($model=null) {
        if ($model) {
            $this->model = $model;
        }
        return $this->model;
    }
    public function instructions($instructions=null) {
        if ($instructions) {
            $this->instructions = $instructions;
        }
        return $this->instructions;
    }
    public function tools($tools=null) {
        if ($tools) {
            $this->tools = $tools;
        }
        return $this->tools;
    }
    public function fileIds($fileIds=null) {
        if ($fileIds) {
            $this->fileIds = $fileIds;
        }
        return $this->fileIds;
    }
    public function metadata($metadata=null) {
        if ($metadata) {
            $this->metadata = $metadata;
        }
        return $this->metadata;
    }

    public function save() {
        $parameters = [
            "model" => $this->model,
            "name" => $this->name,
            "description" => $this->description,
            "instructions" => $this->instructions,
            "tools" => $this->tools,
            "file_ids" => $this->fileIds,
            "metadata" => $this->metadata
        ];
        if($this->id) {
            $result = Assistants::update($this->id,$parameters);
        } else {
            $result = Assistants::create($parameters);
            $this->id = $result->id();
        }
        if($result["id"]) {
            return $this;
        }
        return false;
        //return $this->request("patch","assistants/".$this->id,$parameters);
    }

    /**
     * 
     * @return Run|false 
     * @param $returnRun bool - if true, return the Run object instead of the result
     * @throws Exception 
     */
    public function run($returnRun=false) {
        if(!$this->thread) {
            throw new \Exception("Thread not found. Add a message first to create one.");
        }
        $parameters = [
            "assistant_id" => $this->id,
            "thread" => [
                "messages" => $this->thread->getMessages()
            ]
        ];

        $run = Threads::run($parameters);
        if($returnRun) {
            return $run;
        } else {
            return new AssistantResponse($run->result());
        }
    }
    public function addMessage($role,$content) {
        if(!$this->thread) {
            $this->thread = new Thread();
        }
        $this->thread->addMessage($role,$content);
    }
}