<?php
namespace boru\openai\models;

use boru\openai\api\responses\ApiBaseResponse;

class Base {
    public function __construct($options=[]) {
        if($options instanceof ApiBaseResponse) {
            $options = $options->asArray();
        }
        foreach($options as $key=>$value) {
            if(method_exists($this,$key)) {
                $this->$key($value);
            } elseif(strpos($key,"_") !== false) {
                $parts = explode("_",$key);
                $start = array_shift($parts);
                $parts = array_map(function($part) {
                    return ucfirst($part);
                },$parts);
                $key = $start . implode("",$parts);
                if(method_exists($this,$key)) {
                    $this->$key($value);
                }
            }
        }
    }
}