<?php
namespace boru\openai\models;

use boru\openai\api\endpoints\Messages;

class Message extends Base {
    private $id;
    private $object = "thread.message";
    private $createdAt;
    private $threadId;
    private $role;
    private $content;
    private $assistantId;
    private $runId;
    private $fileIds;
    private $metadata;

    public function id($id=null) {
        if ($id) {
            $this->id = $id;
        }
        return $this->id;
    }
    public function object($object=null) {
        if ($object) {
            $this->object = $object;
        }
        return $this->object;
    }
    public function createdAt($created=null) {
        if ($created) {
            $this->createdAt = $created;
        }
        return $this->createdAt;
    }
    public function threadId($threadId=null) {
        if ($threadId) {
            $this->threadId = $threadId;
        }
        return $this->threadId;
    }
    /**
     * Get or set the role of the message
     * @param mixed $role [user|assistant]
     * @return string|null 
     */
    public function role($role=null) {
        if ($role) {
            $this->role = $role;
        }
        return $this->role;
    }
    public function content($content=null) {
        if ($content) {
            $this->content = $content;
        }
        return $this->content;
    }
    public function assistantId($assistantId=null) {
        if ($assistantId) {
            $this->assistantId = $assistantId;
        }
        return $this->assistantId;
    }
    public function runId($runId=null) {
        if ($runId) {
            $this->runId = $runId;
        }
        return $this->runId;
    }
    public function fileIds($fileIds=null) {
        if ($fileIds) {
            $this->fileIds = $fileIds;
        }
        return $this->fileIds;
    }
    public function metadata($metadata=null) {
        if ($metadata) {
            $this->metadata = $metadata;
        }
        return $this->metadata;
    }

    public function save() {
        $data = [
            "thread_id"=>$this->threadId(),
            "rolw"=>$this->role(),
            "content"=>$this->content(),
        ];
        if($this->fileIds()) {
            $data["file_ids"] = $this->fileIds();
        }
        if($this->metadata()) {
            $data["metadata"] = $this->metadata();
        }
        $result = Messages::create($data);
        $this->id($result->id());
        $this->object($result->object());
        $this->createdAt($result->createdAt());
        $this->threadId($result->threadId());
        $this->role($result->role());
        $this->content($result->content());
        $this->assistantId($result->assistantId());
        $this->runId($result->runId());
        $this->fileIds($result->fileIds());
        $this->metadata($result->metadata());
        return $this;
    }

    public function forThread() {
        $arr = ["role"=>$this->role(),"content"=>$this->content()];
        if($this->fileIds()) {
            $arr["file_ids"] = $this->fileIds();
        }
        return $arr;
    }
}