<?php
namespace boru\openai\models;

use boru\openai\api\endpoints\Messages;
use boru\openai\api\responses\ApiListResponse;
use Exception;

class Run extends Base {
    private $id;
    private $object = "thread.run";
    private $createdAt;
    private $threadId;
    private $assistantId;
    private $status;
    private $requiredAction;
    private $lastError;
    private $expiresAt;
    private $startedAt;
    private $cancelledAt;
    private $failedAt;
    private $completedAt;
    private $model;
    private $instructions;
    private $tools;
    private $fileIds;
    private $metadata;

    public function id($id=null) {
        if ($id) {
            $this->id = $id;
        }
        return $this->id;
    }
    public function object($object=null) {
        if ($object) {
            $this->object = $object;
        }
        return $this->object;
    }
    public function createdAt($created=null) {
        if ($created) {
            $this->createdAt = $created;
        }
        return $this->createdAt;
    }
    public function threadId($threadId=null) {
        if ($threadId) {
            $this->threadId = $threadId;
        }
        return $this->threadId;
    }
    public function thread_id($threadId=null) {
        return $this->threadId($threadId);
    }
    public function assistantId($assistantId=null) {
        if ($assistantId) {
            $this->assistantId = $assistantId;
        }
        return $this->assistantId;
    }
    public function status($status=null) {
        if ($status) {
            $this->status = $status;
        }
        return $this->status;
    }
    public function requiredAction($requiredAction=null) {
        if ($requiredAction) {
            $this->requiredAction = $requiredAction;
        }
        return $this->requiredAction;
    }
    public function lastError($lastError=null) {
        if ($lastError) {
            $this->lastError = $lastError;
        }
        return $this->lastError;
    }
    public function expiresAt($expiresAt=null) {
        if ($expiresAt) {
            $this->expiresAt = $expiresAt;
        }
        return $this->expiresAt;
    }
    public function startedAt($startedAt=null) {
        if ($startedAt) {
            $this->startedAt = $startedAt;
        }
        return $this->startedAt;
    }
    public function cancelledAt($cancelledAt=null) {
        if ($cancelledAt) {
            $this->cancelledAt = $cancelledAt;
        }
        return $this->cancelledAt;
    }
    public function failedAt($failedAt=null) {
        if ($failedAt) {
            $this->failedAt = $failedAt;
        }
        return $this->failedAt;
    }
    public function completedAt($completedAt=null) {
        if ($completedAt) {
            $this->completedAt = $completedAt;
        }
        return $this->completedAt;
    }
    public function model($model=null) {
        if ($model) {
            $this->model = $model;
        }
        return $this->model;
    }
    public function instructions($instructions=null) {
        if ($instructions) {
            $this->instructions = $instructions;
        }
        return $this->instructions;
    }
    public function tools($tools=null) {
        if ($tools) {
            $this->tools = $tools;
        }
        return $this->tools;
    }
    public function fileIds($fileIds=null) {
        if ($fileIds) {
            $this->fileIds = $fileIds;
        }
        return $this->fileIds;
    }
    public function metadata($metadata=null) {
        if ($metadata) {
            $this->metadata = $metadata;
        }
        return $this->metadata;
    }

    /**
     * Check the status of this run
     * @return bool true if the run is completed, false otherwise
     * @throws Exception
     */
    public function checkStatus() {
        $run = \boru\openai\api\endpoints\Runs::getRun($this->threadId(),$this->id());
        //print_r($run);
        $this->status($run->status());
        if(in_array($this->status(),["completed","failed","cancelled","expired"])) {
            return true;
        }
        $this->requiredAction($run->requiredAction());
        $this->lastError($run->lastError());
        $this->expiresAt($run->expiresAt());
        $this->startedAt($run->startedAt());
        $this->cancelledAt($run->cancelledAt());
        $this->failedAt($run->failedAt());
        $this->completedAt($run->completedAt());
        return false;
    }
    /**
     * Get the messages for this run
     * @return Message[]|false 
     * @throws Exception 
     */
    public function getMessages() {
        $output = [];
        $messages = Messages::listMessages($this->threadId());
        foreach($messages as $message) {
            $output[] = $message;
        }
        return $output;
    }

    public function result() {
        while(!$this->checkStatus()) {
            sleep(1);
        }
        $messages = $this->getMessages();
        $response = $messages[0];
        return $response->content();
    }
}