<?php
namespace boru\openai\models;

use boru\openai\api\endpoints\Messages;
use boru\openai\api\endpoints\Threads;

class Thread extends Base {
    private $id;
    private $object = "thread";
    private $createdAt;
    private $metadata;

    /** @var Message[] */
    private $messages = [];

    public function id($id=null) {
        if ($id) {
            $this->id = $id;
        }
        return $this->id;
    }
    public function object($object=null) {
        if ($object) {
            $this->object = $object;
        }
        return $this->object;
    }
    public function createdAt($created=null) {
        if ($created) {
            $this->createdAt = $created;
        }
        return $this->createdAt;
    }
    public function metadata($metadata=null) {
        if ($metadata) {
            $this->metadata = $metadata;
        }
        return $this->metadata;
    }

    public function save() {
        $data = [];
        if($this->metadata) {
            $data["metadata"] = $this->metadata;
        }
        $result = Threads::create($data);
        $this->id($result->id());
        $this->object($result->object());
        $this->createdAt($result->createdAt());
        $this->metadata($result->metadata());
        if(!empty($this->messages)) {
            foreach($this->messages as $message) {
                $message->threadId($this->id());
                $message->save();
            }
        
        }
    }
    public function addMessage($role,$content,$fileIds=[],$metadata=[]) {
        $data = [
            "role" => $role,
            "content" => $content,
            "fileIds" => $fileIds,
            "metadata" => $metadata
        ];
        $result = new Message($data);
        $this->messages[] = $result;
    }
    /**
     * 
     * @param bool $forRun 
     * @return array|Message[]
     */
    public function getMessages($forRun=true) {
        if(!$forRun) {
            return $this->messages;
        }
        $messages = [];
        foreach($this->messages as $message) {
            $messages[] = $message->forThread();
        }
        return $messages;
    }
}