# Assistants
#### [Back to main page](README.md)
In the configuration file, the assistants entry contains a list of "names" to "assistant_id" values, as a shortcut to loading assistants by name. The assistant_id is the id of the assistant model in the OpenAI API.


## Initialize an Assistant

```php
use Boru\OpenAI\OpenAI;
use boru\openai\models\Assistant;

OpenAI::init();
$assistant = Assistant::fromFile("assistant.json");
echo $assistant->id();

//use that same assistant again in the future
$assistant = Assistant::fromName("Boru Default Summary Assistant");
//or by id
$assistant = Assistant::fromId("assistant-id");
```

## Run Assistant

```php
use Boru\OpenAI\OpenAI;
use boru\openai\models\Assistant;
use boru\openai\models\Content;

OpenAI::init();

//load by name, or by id
$parseAssistant = OpenAI::assistant("parse");
if(!$parseAssistant) {
    throw new \Exception("No parse assistant found, please set one in the config: assistants.parse");
}
$content = new Content();
$content->addText("extract the information from the provided text");
$content->addText("The text is: 'The quick brown fox jumps over the lazy dog.'");
$parseAssistant->addMessage("user",$content);
echo $parseAssistant->run("\n");
```

## Create Assistant
Assistants can be created using PHP:
```php
use Boru\OpenAI\OpenAI;
use boru\openai\models\Assistant;

OpenAI::init();
$assistant = new Assistant();
$assistant->name("Boru Default Summary Assistant");
$assistant->model("gpt-4o");
$assistant->instructions("This GPT assists with identifying information from uploaded PDFs and extract key information from the PDFs. The PDFs have been split into images with one image per page. Please write a summary of each page, extracting precise information such as names/addresses/locations and financial details. The summary will be utilized to provide context for additional pages, so must contain all relevant information to accurately summarize the entire document.");
$assistant->addTool("code_interpreter");
$assistant->addTool("file_search");
$assistant->save();
```

They can also be loaded from json files.. example: `assistant.json`
```json
{
    "object": "assistant",
    "name": "Boru Default Summary Assistant",
    "description": null,
    "model": "gpt-4o",
    "instructions": "This GPT assists with identifying information from uploaded PDFs and extract key information from the PDFs. The PDFs have been split into images with one image per page. Please write a summary of each page, extracting precise information such as names/addresses/locations and financial details. The summary will be utilized to provide context for additional pages, so must contain all relevant information to accurately summarize the entire document.",
    "tools": [
        {
            "type": "code_interpreter"
        },
        {
            "type": "file_search"
        }
    ],
    "file_ids": null,
    "metadata": null
}
```

## Update Assistant
Assistants can be updated using PHP:
```php
use Boru\OpenAI\OpenAI;
use boru\openai\models\Assistant;

OpenAI::init();
$assistant = Assistant::fromName("Boru Default Summary Assistant");
$assistant->instructions("This GPT assists with identifying information from uploaded PDFs and extract key information from the PDFs. The PDFs have been split into images with one image per page. Please write a summary of each page, extracting precise information such as names/addresses/locations and financial details. The summary will be utilized to provide context for additional pages, so must contain all relevant information to accurately summarize the entire document.");
$assistant->save();
```