# OCR
#### [Back to main page](README.md)
There are several helper tools to assist with OCR operations on files.


## OCR
To ocr a standaline image, you can utilize this simple static class/method
    
```php
use Boru\OpenAI\OpenAI;
use boru\openai\tools\OCR;

OpenAI::init();

//for a file.jpg
$ocr = OCR::ocrFile("file.jpg");

//for an openai file id
$ocr = OCR::ocrFileId("fileid");

//for a publically accessible url
$ocr = OCR::ocrFileUrl("https://example.com/file.jpg");

echo $ocr;
```

## PDF Converter

The PDF Converter tool is designed to convert PDF files into images and upload them for further processing.

## Usage

### PHP Code Example
```php
use boru\openai\tools\PDFConverter;

$inputFile = "somefile.pdf";

$converter = new PDFConverter($inputFile,__DIR__.'/output/');
$outputFiles = $converter->convert();
$fileIds = $converter->upload();