<?php

namespace boru\openai\command;

use boru\dhcli\Option;
use boru\openai\api\endpoints\Assistants;
use boru\openai\models\Assistant;

class AssistantCommand extends BaseCommand {
    public static $commandName = "assistant";
    public static $commandDescription = "assistant endpoint actions";
    public static function setCommandOptions() {
        return [
            Option::positional("command","The command to execute",true,["options"=>["list","get","create","update","delete"]]),
            Option::option("i","id","Assistant ID",false),
            Option::option("f","file","The file to read/write",false),
        ];
    }

    private $output;

    public function __construct($result) {
        parent::__construct($result);
        $command = $this->get("command","list");
        switch ($command) {
            case "list":
                $this->listCommand();
                break;
            case "get":
                $this->getCommand();
                break;
            case "create":
                $this->createCommand();
                break;
            case "update":
                $this->updateCommand();
                break;
            default:
                $this->error("Invalid command: $command");
        }
    }

    public function listCommand() {
        $assistants = Assistants::listAssistants();
        foreach($assistants as $assistant) {
            $this->output($assistant->id(),"\t",$assistant->name());
        }
    }
    public function getCommand() {
        $assistant_id = $this->get("id");
        $assistant = Assistant::fromId($assistant_id);
        if($assistant) {
            $assistant->saveToTable();
            $outFile = $this->get("file",false);
            if($outFile) {
                $assistant->toFile($outFile);
            }
            $data=json_encode($assistant->toArray(),JSON_PRETTY_PRINT);
            $this->output($data);
        }
        
    }

    public function createCommand() {
        $file = $this->get("file",false);
        if($file && file_exists($file)) {
            $assistant = Assistant::fromFile($file,true);
            $this->output("Assistant created with ID:");
            $this->output($assistant->id());
        } else {
            $this->error("File is required to create assistant");
        }
    }
    public function updateCommand() {
        $file = $this->get("file",false);
        if($file && file_exists($file)) {
            $assistant = Assistant::fromFile($file,false);
            $this->output("Assistant updated with ID:");
            $this->output($assistant->id());
        } else {
            $this->error("File is required to update assistant");
        }
    }
}