<?php
namespace boru\openai\command;

use boru\dhcli\ClassCommandInterface;
use boru\dhcli\Option;
use boru\dhutils\dhGlobal;
use boru\openai\OpenAI;
use boru\openai\tools\OpenAIConfig;

abstract class BaseCommand implements ClassCommandInterface {
    public static $commandName;
    public static $commandDescription;
    public static $commandOptions = [];

    protected $cliResult;
    protected $lockFile;
    protected $lockEnabled=false;

    protected $config = [
        "openai" => [
            "api_key" => ""
        ]
    ];

    protected static function commonOptions() {
        return [
            Option::option(  "", "key", "API Key to use for OpenAI -- either this or config.json must be used", false ),
            Option::option( "c","config","Specify the .json config file to use. If it doesn't exist, a template is created in it's place",false ),
            Option::option( "d","debug","Debug level to print",false,["default"=>"none","options"=>["none","error","debug","all"]]),
            Option::option( "t","threads","Number of threads to use for multithreaded operations",false,["default"=>5]),
        ];
    }

    protected function initResult($result) {
        $this->cliResult = $result;
    }
    protected function get($opt,$default=null) {
        return dhGlobal::getVal($this->cliResult["options"],$opt,$default);
    }
    protected function opt($opt,$default=null) {
        return $this->get($opt,$default);
    }
    protected function getOpt($opt,$default=null) {
        return $this->get($opt,$default);
    }
    protected function config($key,$default=null) {
        return dhGlobal::getVal($this->config,$key,$default);
    }

    public function __construct($result) {
        if($this->lockEnabled) {
            if(is_null($this->lockFile)) {
			    $this->lockFile = dirname(__FILE__)."/../../tmp/".static::commandName().".lock";
            }
			if($this->isLocked()) {
				throw new \Exception("Already Running");
			}
			$this->Lock();
		}
        $this->initResult($result);
        $this->processCommonOptions();
    }

    private function processCommonOptions() {
        $debugLevel = $this->get("debug","none");
        if($debugLevel == "all") {
            dhGlobal::logger("debugger",dhGlobal::LOG_ALL,true,false);
        } elseif($debugLevel == "debug") {
            dhGlobal::logger("debugger",dhGlobal::LOG_ALL & ~dhGlobal::LOG_TRACE,true,false);
        } elseif($debugLevel == "error") {
            dhGlobal::logger("debugger",dhGlobal::LOG_ALL & ~dhGlobal::LOG_TRACE & ~dhGlobal::LOG_INFO & ~dhGlobal::LOG_DEBUG,true,false);
        }

        $openAiKey = $this->get("key",null);
        $configFile = $this->get("config",null);
        OpenAI::init($openAiKey,$configFile);
        if(OpenAIConfig::get("openai.api_key","") == "") {
            throw new \Exception("OpenAI API Key not set, please set in config file in openai.api_key or use --key");
        }
    }
    

    public static function getStaticName() {
        return static::class;
    }
    public static function commandName() {
        static::__commandPreInit();
        return static::$commandName;
    }
    public static function commandDescription() {
        return static::$commandDescription;
    }
    public static function commandOptions() {
        $opts = static::commonOptions();
        if(!empty(static::$commandOptions)) {
            foreach(static::$commandOptions as $opt) {
                $opts[] = $opt;
            }
        }
        return $opts;
    }
    public static function setCommandOptions() { }
    protected static $isPreInit=false;
    public static function commandPreInit() {
        static::$commandOptions = static::setCommandOptions();
    }
    private static function __commandPreInit() {
        static::commandPreInit();
    }


    function isLocked() {
		if(file_exists($this->lockFile)) {
			$lockingPID = trim(file_get_contents($this->lockFile));
			$pids = explode("\n",trim( `ps -e | awk '{print $1}'` ));
			if(in_array($lockingPID,$pids)) return true;
			unlink($this->lockFile);
		}
		return false;
	}
	function Lock() {
		if(!$this->isLocked()) {
			file_put_contents($this->lockFile,getmypid()."\n");
		}
		return true;
	}

    /**
     * @param mixed ...$args
     * Output a message
     */
    public function output(...$args) {
        dhGlobal::outLine(...$args);
    }

    /**
     * @param mixed ...$args
     * Output an error message and exit
     */
    public function error(...$args) {
        dhGlobal::outLine("ERROR:",...$args);
        exit();
    }
}