<?php

namespace boru\openai\command;

use boru\dhcli\Option;
use boru\openai\api\endpoints\Models;

class ModelCommand extends BaseCommand {
    public static $commandName = "model";
    public static $commandDescription = "model endpoint actions";
    public static function setCommandOptions() {
        return [
            Option::positional("command","The command to execute",true,["options"=>["list","get"]]),
        ];
    }

    private $output;

    public function __construct($result) {
        parent::__construct($result);
        $command = $this->get("command","list");
        switch ($command) {
            case "list":
                $this->listCommand();
                break;
            case "get":
                $this->getCommand();
                break;
            default:
                $this->error("Invalid command: $command");
        }
    }

    public function listCommand() {
        $models = Models::listModels();
        foreach($models as $model) {
            $this->output($model->id());
        }
    }
    public function getCommand() {
        $model_id = $this->get("id");
        $this->output = Models::getModel($model_id);
    }
}