<?php
namespace boru\openai\models;

class Content extends Base {

    private $body;

    public function __construct($contentBody=[]) {
        if(!is_array($contentBody)) {
            $this->body = [];
            if(is_string($contentBody)) {
                $this->addText($contentBody);
            } else {
                throw new \Exception("Options must be an array or string");
            }
        }
        $this->body = $contentBody;
    }

    public function addText($text) {
        $this->body[] = [
            "type"=> "text",
            "text"=>$text,
        ];
        return $this;
    }
    public function addImageFile($fileId,$detail="high") {
        $this->body[] = [
            "type"=> "image_file",
            "image_file"=>["file_id"=>$fileId,"detail"=>$detail],
        ];
        return $this;
    }
    public function addAudioFile($fileId) {
        $this->body[] = [
            "type"=> "audio_file",
            "audio_file"=>["file_id"=>$fileId],
        ];
        return $this;
    }
    public function addImageUrl($url) {
        $this->body[] = [
            "type"=> "image_url",
            "image_url"=>["url"=>$url],
        ];
        return $this;
    }


    public function toArray() {
        return $this->body;
    }

}