<?php
namespace boru\openai\models;

use boru\openai\api\endpoints\Assistants;
use boru\openai\api\endpoints\Threads;
use boru\openai\api\responses\AssistantResponse;
use Exception;

class ListItem extends Base {
    private $data = [];

    public function __construct($data) {
        $this->data = $data;
    }

    public function toArray() {
        return $this->data;
    }

    public function __call($name, $arguments) {
        //if key exists in data, set it if there is an argument, otherwise return the value.
        if(array_key_exists($name, $this->data)) {
            if(count($arguments) > 0) {
                $this->data[$name] = $arguments[0];
                return $this;
            }
            return $this->data[$name];
        }
        //convert key to camelCase if snake_case and try again
        $snakeCase = strtolower(preg_replace('/(?<!^)[A-Z]/', '_$0', $name));
        if(array_key_exists($snakeCase, $this->data)) {
            if(count($arguments) > 0) {
                $this->data[$snakeCase] = $arguments[0];
                return $this;
            }
            return $this->data[$snakeCase];
        }

        //convert key to snake_case if camelCase and try again
        $camelCase = lcfirst(str_replace(' ', '', ucwords(str_replace('_', ' ', $name))));
        if(array_key_exists($camelCase, $this->data)) {
            if(count($arguments) > 0) {
                $this->data[$camelCase] = $arguments[0];
                return $this;
            }
            return $this->data[$camelCase];
        }
    }
}