<?php
namespace boru\openai\tools;

use boru\dhutils\dhGlobal;
use boru\openai\models\PDFDocument;

class DocProcessor {
    public $lockFile;
    public $what = "all";

    public function __construct($lockName="all") {
        $this->lockFile = dirname(__FILE__)."/../../tmp/".basename(__FILE__)."_".$lockName.".lock";
        $this->lock();
        $this->what = $lockName;
    }
    public function __destruct() {
        $this->unlock();
    }

    public function run($what=null) {
        if($what === null) {
            $what = $this->what;
        }
        if($what == "all") {
            return $this->all();
        }
        if($what == "paging" || $what == "page") {
            return $this->paging();
        }
        if($what == "summarizing" || $what == "summarize" || $what == "summary") {
            return $this->summarizing();
        }
        if($what == "parsing" || $what == "parse") {
            return $this->parsing();
        }
    }

    public function all() {
        $this->paging();
        $this->summarizing();
        $this->parsing();
    }

    public function paging() {
        dhGlobal::outLine("Starting Paging process");
        $docs = PDFDocument::getNeedsPaged();
        if(count($docs) == 0) {
            dhGlobal::outLine("No documents need paging");
            return;
        }
        foreach($docs as $doc) {
            try {
                $doc->upload(false,true);
                dhGlobal::outLine("- Document uploaded to OpenAI: ".$doc->id());
            } catch (\Exception $e) {
                dhGlobal::outLine("! Error converting/uploading document: ".$doc->id()."\t".$e->getMessage());
                continue;
            }
        }
        dhGlobal::outLine("Finished Paging process");
    }
    public function summarizing() {
        dhGlobal::outLine("Starting Summarizing process");
        $docs = PDFDocument::getNeedsSummarized();
        if(count($docs) == 0) {
            dhGlobal::outLine("No documents need summarizing");
            return;
        }
        foreach($docs as $doc) {
            try {
                $doc->summarize();
                dhGlobal::outLine("- Document summarized: ".$doc->id());
            } catch (\Exception $e) {
                dhGlobal::outLine("! Error summarizing document: ".$doc->id()."\t".$e->getMessage());
                continue;
            }
        }
        dhGlobal::outLine("Finished Summarizing process");
    }
    public function parsing() {
        dhGlobal::outLine("Starting Parsing process");
        $docs = PDFDocument::getNeedsParsed();
        if(count($docs) == 0) {
            dhGlobal::outLine("No documents need parsing");
            return;
        }
        foreach($docs as $doc) {
            try {
                $doc->parse();
                dhGlobal::outLine("- Document parsed: ".$doc->id());
            } catch (\Exception $e) {
                dhGlobal::outLine("! Error parsing document: ".$doc->id()."\t".$e->getMessage());
                continue;
            }
        }
        dhGlobal::outLine("Finished Parsing process");
    }

    public function lock() {
        if($this->isLocked()) {
            throw new \Exception("Already Running");
        }
    }
    public function unlock() {
        if(file_exists($this->lockFile)) {
            unlink($this->lockFile);
        }
    }

    public function isLocked(){
        # If lock file exists, check if stale.  If exists and is not stale, return TRUE
        # Else, create lock file and return FALSE.
    
        if (file_exists($this->lockFile)) {
            # check if it's stale
            $lockingPID = trim(file_get_contents($this->lockFile));
    
            # Get all active PIDs.
            $pids = explode("\n", trim(`ps -e | awk '{print $1}'`));
    
            # If PID is still active, return true
            if (in_array($lockingPID, $pids)) return true;
    
            # Lock-file is stale, so kill it.  Then move on to re-creating it.
            echo "Removing stale lock file.\n";
            unlink($this->lockFile);
        }
    
        file_put_contents($this->lockFile, getmypid() . "\n");
        return false;
    
    }
}