<?php
namespace boru\openai\tools;

use boru\dhprocess\Task;
use boru\dhprocess\TaskQueue;
use boru\dhutils\dhGlobal;
use boru\openai\models\Assistant;
use boru\openai\models\Content;
use boru\openai\models\File;
use boru\openai\OpenAI;
use boru\openai\tools\OCR;

class Iterator {
    private $content = [];
    private $files = [];
    private $prompt = "Here is the first {count} ocrd content sets. Remember to deduplicate and list the players and scores.";
    private $beforePrompt = "";
    private $afterPrompt = "";

    private $filesPerRun = 3;

    private $totalFiles = 0;
    private $filesProcessed = 0;

    private $assistant;

    public function __construct($files=null,$assistant="summary") {
        if($files !== null) {
            if(!is_array($files)) {
                $files = json_decode($files,true);
                if(!is_array($files)) {
                    throw new \Exception("Files must be an array");
                }
            }
            foreach($files as $file) {
                $this->addFile($file);
            }
        }
        if($assistant) {
            $this->assistant($assistant);
        }
    }

    public function files($files=null) {
        if($files !== null) {
            $this->files = $files;
        }
        return $this->files;
    }
    public function content($content=null) {
        if($content !== null) {
            $this->content = $content;
        }
        return $this->content;
    }
    public function prompt($prompt=null) {
        if($prompt !== null) {
            $this->prompt = $prompt;
        }
        return $this->prompt;
    }
    public function beforePrompt($beforePrompt=null) {
        if($beforePrompt!== null) {
            $this->beforePrompt= $beforePrompt;
        }
        return $this->beforePrompt;
    }
    public function afterPrompt($afterPrompt=null) {
        if($afterPrompt !== null) {
            $this->afterPrompt = $afterPrompt;
        }
        return $this->afterPrompt;
    }
    public function assistant($assistant=null) {
        if($assistant!==null) {
            if($assistant instanceof Assistant) {
                $this->assistant = $assistant;
            } else {
                $this->assistant = Assistant::fromInput($assistant);
            }
        }
        return $this->assistant;
    }
    public function addFile($file) {
        if($file instanceof File) {
            $this->files[] = $file;
        } elseif(is_string($file)) {
            if(!file_exists($file)) {
                throw new \Exception("File not found: ".$file);
            }
            $file = File::upload($file);
            if($file) {
                $file->ocr();
                $file->save();
                $this->files[] = $file;
            } else {
                throw new \Exception("File not uploaded: ".$file);
            }
        } else {
            throw new \Exception("Invalid file type");
        }
    }
    public function run() {
        $fileData = [];
        foreach($this->files as $file) {
            if($file instanceof File) {
                if($file->ocrContent() === null) {
                    $file->ocr();
                    $file->save();
                }
                if($file->ocrContent() === null) {
                    dhGlobal::outLine("File not processed: ".$file->id());
                    continue;
                }
                $fileData[] = $file->ocrContent();
            } else {
                throw new \Exception("Invalid file type ".json_encode($file));
            }
            
        }
        $this->runFiles($fileData);
        return $this->content;
    }

    private function runFiles($fileData) {
        $groupOfData = [];
        foreach($fileData as $i => $data) {
            $groupOfData[] = $data;
            $this->filesProcessed++;
            if($this->filesProcessed % $this->filesPerRun == 0 || $this->filesProcessed == count($fileData)) {
                $this->runGroup($groupOfData);
                $groupOfData = [];
            }
        }
    }

    private function prompts($thisCount) {
        $prompts = [
            "before" => $this->beforePrompt,
            "after" => $this->afterPrompt,
            "run" => $this->prompt
        ];
        return $prompts;
    }
    private function runGroup($groupOfData) {
        $replace = [
            "\r\n",
            "\n",
        ];

        $prompts = $this->prompts(count($groupOfData));
        $content = new Content();
        $preview = [];;
        $totalData = "";
        if(!empty($prompts["before"])) {
            $totalData .= $prompts["before"]."\n";
            $content->addText($prompts["before"]);
            $preview[] = substr($prompts["before"],0,100);
        }
        $content->addText($prompts["run"]);

        $preview[] = str_replace($replace," ",substr($prompts["run"],0,500));
       
        $totalData .= $prompts["run"]."\n";
        foreach($groupOfData as $data) {
            $totalData.="\n".$data;
            $preview[] = str_replace($replace," ",substr($data,0,100));
        }
        if(!empty($prompts["after"])) {
            $totalData.= "\n".$prompts["after"];
            //$content->addText($prompts["after"]);
            $preview[] = substr($prompts["after"],0,100);
        }
        $content->addText($totalData);
        dhGlobal::outLine("Running",count($groupOfData),"files");
        dhGlobal::outLine("Request Preview\n".implode("\n",$preview));
        $this->assistant()->addMessage("user",$content);
        $result = $this->assistant->run("\n");
        $lines = explode("\n",$result);
        if(count($lines) > 3) {
            $this->content[] = $result;
        }
        dhGlobal::outLine("Content: ".$result);
        return $this->content;
    }
}