<?php
namespace boru\openai\tools;

use boru\dhprocess\Task;
use boru\dhprocess\TaskQueue;
use boru\dhutils\dhGlobal;
use boru\openai\models\File;
use boru\openai\OpenAI;
use boru\openai\tools\OCR;

class OCRBulk {

    private static $isInit = false;
    private static $callable;
    public static function init($bootstrapFile,$queueOptions=[]) {
        if(!file_exists($bootstrapFile)) {
            throw new \Exception("Bootstrap file does not exist");
        }

        $function = function($options) {
            if(isset($options["filePath"])) {
                $file = File::upload($options["filePath"]);
                if($file instanceof File) {
                    unset($options["filePath"]);
                    $options["fileId"] = $file->id();
                } else {
                    throw new \Exception("Failed to upload file");
                }
            } elseif(isset($options["fileId"])) {
                $file = File::fromId($options["fileId"]);
                if($file) {
                    $options["fileId"] = $file->id();
                } else {
                    throw new \Exception("File not found: ".$options["fileId"]);
                }
            } else {
                throw new \Exception("No file specified ".json_encode($options));
            }
            $ocr = new OCR($options);
            $content = $ocr->run();
            $file->ocrContent($content);
            $file->save();
            return $content;
        };

        $function2 = function($options) {
            return $options;
        };

        static::$callable = $function;

        $options = [
            "numWorkers"=>5,
            "maxQueued"=>100,
            "extendedBar"=>true,
            "bootstrapFile"=>$bootstrapFile,
            "done"=>true,
        ];
        $options = array_merge($options,$queueOptions);
        dhGlobal::outLine("OCR Bulk Init with options: ".json_encode($options));
        TaskQueue::init($options);
        Task::register("ocrbulk",$function);
        static::$isInit = true;
    }


    private $deleteOnComplete = false;
    private $ocrDetail = "high";
    private $before = "";
    private $after = "";
    private $files = [];
    public function __construct($files=null) {
        if(!static::$isInit) {
            throw new \Exception("OCR Bulk not initialized, call OCRBulk::init() first");
        }
        if($files !== null) {
            if(!is_array($files)) {
                $files = json_decode($files,true);
                if(!is_array($files)) {
                    throw new \Exception("Files must be an array");
                }
            }
            foreach($files as $file) {
                $this->addFile($file);
            }
        }
    }

    public function deleteOnComplete($deleteOnComplete=null) {
        if($deleteOnComplete !== null) {
            $this->deleteOnComplete = $deleteOnComplete;
        }
        return $this->deleteOnComplete;
    }
    public function ocrDetail($ocrDetail=null) {
        if($ocrDetail !== null) {
            $this->ocrDetail = $ocrDetail == "low" ? "low" : "high";
        }
        return $this->ocrDetail == "low" ? "low" : "high";
    }
    public function files($files=null) {
        if($files !== null) {
            $this->files = $files;
        }
        return $this->files;
    }
    public function before($before=null) {
        if($before !== null) {
            $this->before = $before;
        }
        return $this->before;
    }
    public function after($after=null) {
        if($after !== null) {
            $this->after = $after;
        }
        return $this->after;
    }
    public function addFile($file) {
        if($file instanceof File) {
            $this->files[] = $file->id();
        } elseif(is_string($file)) {
            if(!file_exists($file)) {
                throw new \Exception("File not found: ".$file);
            }
            $this->files[] = $file;
        } else {
            throw new \Exception("Invalid file type");
        }
    }
    public function run() {
        foreach($this->files as $file) {

            $runFile = "";
            if(is_string($file)) {
                $runFile = $file;
            } elseif($file instanceof File) {
                $runFile = $file->id();
            } else {
                throw new \Exception("Invalid file type");
            }


            $options = $this->makeOptions($runFile);
            dhGlobal::outLine("Adding OCR Task: ".$runFile,json_encode($options));
            TaskQueue::task("ocrbulk",[$options])->onDone(function($result,$task) {
                $lines = explode("\n",$result);
                $task->description("OCR Task Done: with ".strlen($result)." bytes and ".count($lines)." lines");
            });
        }
        TaskQueue::wait();
    }
    public function runOne() {
        $file = array_shift($this->files);
        $options = $this->makeOptions($file);
        $func = static::$callable;
        return $func($options);
    }

    private function makeOptions($file) {
        $options = [
            "fileId"=>$file,
            "detail"=>$this->ocrDetail,
            "deleteFile"=>$this->deleteOnComplete,
        ];
        if($this->before) {
            $options["before"] = $this->before;
        }
        if($this->after) {
            $options["after"] = $this->after;
        }
        return $options;
    }
}