<?php
namespace boru\openai\tools;

use boru\dhutils\dhGlobal;
use boru\openai\OpenAI;

class OpenAIConfig {
    private static $schemaVersion = 1;
    private static $configFile = "config_boruai.json";
    private static $config = [
        "schema" => 1,
        "openai" => [
            "api_key" => ""
        ],
        "assistants" => [
            "summary" => "",
        ],
        "outputdir" => __DIR__."/../../output/",
        "tables" => [
            "files" => "boru_openai_files",
            "documents" => "boru_openai_documents",
            "pages" => "boru_openai_pages",
            "assistants" => "boru_openai_assistants",
            "tools" => "boru_openai_tools",
        ],
        "prompts" => [
            "summary" => [
                "prefix" => "This is part of a larger document that I need to summarize. There are {TOTAL_PAGES} pages in the document. Do not provide a page by page summary, but rather a summary of the entire document.",
                "context" => "Here is the summary of the previous {DONE_PAGES} pages:\n{SUMMARY}",
                "update" => "Using the previous summary, please create an updated summary adding the attached page(s). Retain the previous summary and add/update the new information. Keep the summary brief enough to utilize in further prompts, while retaining important information.",
                "new" => "Please write a summary of the attached page(s). Keep the summary brief enough to utilize in further prompts, while retaining important information.",
            ],
        ],
        "dbconfig" => [
            "use" => false,
            "dbhost" => "localhost",
            "dbport" => 3306,
            "dbname" => "",
            "dbuser" => "",
            "dbpass" => "",
            "dbtype" => "mysql",
        ],
    ];

    private static $init = false;

    public static function getConfig() {
        return static::$config;
    }
    public static function get($key,$default=null) {
        return dhGlobal::dotGet(static::$config,$key,$default);
    }
    public static function set($key,$value) {
        return dhGlobal::dotAssign(static::$config,$key,$value);
    }
    public static function save() {
        file_put_contents(self::$configFile,json_encode(static::$config,JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE));
    }

    public static function init($configFile="config_boruai.json") {
        if(!static::$init) {
            static::loadConfig($configFile);
            static::loadConfigFromDefines();
            static::createTables();
            static::$init = true;
        }
    }

    private static function loadConfig($configFile) {
        if(!file_exists($configFile)) {
            static::save();
        }
        self::$configFile = $configFile;
        $newConfig = json_decode(file_get_contents($configFile),true);
        if(!is_array($newConfig)) {
            //throw new \Exception("Config file is not an array");
        } else {
            static::$config = array_replace_recursive(static::$config,$newConfig);
            static::save();
        }
    }
    public static function loadManualConfig($config) {
        if(!is_array($config)) {
            $config = json_decode($config,true);
            if(!is_array($config)) {
                throw new \Exception("Config is not an array");
            }
        }
        static::$config = static::mergeArray(static::$config,$config);
        static::createTables();
        static::$init = true;
        //static::save();
    }
    //"api_key": "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"
    private static function mergeArray($existing,$new) {
        foreach($new as $key => $value) {
            if(is_array($value)) {
                if(!isset($existing[$key])) {
                    $existing[$key] = $value;
                } else {
                    $existing[$key] = static::mergeArray($existing[$key],$value);
                }
            } else {
                if(isset($existing[$key]) && is_array($existing[$key])) {
                    $existing[$key][] = $value;
                } else {
                    $existing[$key] = $value;
                }
            }
        }
        return $existing;
    }
    private static function loadConfigFromDefines() {

        if(!defined("OPENAI_CONFIG")) {
            return false;
        }
        if(!defined("OPENAI_CONFIG")) {
            //this is just to prevent the IDE from complaining
            define("OPENAI_CONFIG",false);
        }
        $defines = json_decode(OPENAI_CONFIG,true);
        if(is_array($defines)) {
            static::$config = array_replace_recursive(static::$config,$defines);
        }
        return true;
    }

    private static function createTables() {
        $db = OpenAI::db();
        if($db !== false) {
            foreach(static::$tableSchemas as $tableBase => $schema) {
                $table = static::get("tables.".$tableBase);
                $schema = str_replace("{{TABLE}}", $table, $schema);
                $db->query($schema, []);
            }
            static::schemaCheck();
        }
    }

    private static function schemaCheck() {
        $schema = static::get("schema",0);
        if($schema < static::$schemaVersion) {
            //update schema
            static::updateSchema($schema);
        }
    }
    private static function updateSchema($schema) {
        $db = OpenAI::db();
        if($db !== false) {
            if($schema < 1) {
                $table = static::get("tables.pages");
                $db->query("ALTER TABLE `$table` ADD COLUMN `content` longtext DEFAULT NULL", []);
                $db->query("ALTER TABLE `$table` CHANGE `summarized` `processed` DATETIME NULL", []);
                $schema = 1;
            }
            /*
            if($schema < 2) {
                //...
                //add more schema updates here
            }
            */
            static::set("schema",static::$schemaVersion);
            static::save();
        }
    }

    private static $tableSchemas = [
        "files"=> "CREATE TABLE IF NOT EXISTS `{{TABLE}}` (
            `id`varchar(100) NOT NULL,
            `object` varchar(100) DEFAULT 'file',
            `created_at` datetime DEFAULT NULL,
            `filename` varchar(255) DEFAULT NULL,
            `purpose` varchar(100) DEFAULT NULL,
            `bytes` int(9) DEFAULT NULL,
            `status_details` longtext DEFAULT NULL,
            `md5` varchar(40) DEFAULT NULL,
            `ocr_content` longtext DEFAULT NULL,
            `ocr_date` datetime DEFAULT NULL,
            PRIMARY KEY (`id`),
            KEY `idx1` (`md5`,`bytes`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
        ",
        "documents" => "CREATE TABLE IF NOT EXISTS `{{TABLE}}` (
            `id` bigint(20) NOT NULL AUTO_INCREMENT,
            `reference` varchar(100) DEFAULT NULL,
            `filename` varchar(255) DEFAULT NULL,
            `pages` int(3) DEFAULT NULL,
            `filesize` int(9) DEFAULT NULL,
            `md5` varchar(40) DEFAULT NULL,
            `created` datetime DEFAULT NULL,
            `userid` bigint(20) DEFAULT NULL,
            `paged` datetime DEFAULT NULL,
            `summarized` datetime DEFAULT NULL,
            `summary` longtext DEFAULT NULL,
            `parsed` datetime DEFAULT NULL,
            `results` longtext DEFAULT NULL,
            PRIMARY KEY (`id`),
            KEY `idx1` (`paged`),
            KEY `idx2` (`summarized`),
            KEY `idx3` (`created`,`userid`),
            KEY `idx4` (`md5`,`pages`,`filesize`),
            KEY `idx5` (`parsed`),
            KEY `idx6` (`reference`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
        ",
        "pages" => "CREATE TABLE IF NOT EXISTS `{{TABLE}}` (
            `id` bigint NOT NULL AUTO_INCREMENT,
            `docid` bigint DEFAULT NULL,
            `openai_fileid` varchar(255) DEFAULT NULL,
            `created` datetime DEFAULT NULL,
            `uploaded` datetime DEFAULT NULL,
            `processed` datetime DEFAULT NULL,
            `content` longtext DEFAULT NULL,
            PRIMARY KEY (`id`),
            KEY `idx1` (`docid`,`created`),
            KEY `idx2` (`uploaded`),
            KEY `idx3` (`processed`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
        ",
        "assistants" => "CREATE TABLE IF NOT EXISTS `{{TABLE}}` (
            `id` varchar(255) NOT NULL,
            `object` varchar(100) DEFAULT 'assistant',
            `model` varchar(30) DEFAULT 'gpt-4o',
            `name` varchar(255) DEFAULT NULL,
            `description` longtext,
            `instructions` longtext,
            `tools` longtext,
            `file_ids` longtext,
            `metadata` longtext,
            PRIMARY KEY (`id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
        ",
        "tools" => "CREATE TABLE IF NOT EXISTS `{{TABLE}}` (
            `id` bigint NOT NULL AUTO_INCREMENT,
            `type` varchar(100) DEFAULT 'function',
            `assistant_id` varchar(255) DEFAULT NULL,
            `name` varchar(255) DEFAULT NULL,
            `description` longtext,
            `callable` varchar(255) DEFAULT NULL,
            `parameters` longtext,
            `strict` int NOT NULL DEFAULT '1',
            PRIMARY KEY (`id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
        ",
    ];
}