# Configuration
#### [Back to main page](README.md)
The library requires a configuration file. You can specify an alternative location/file.json when initializing the library, or the default configuration file will be be named `config_boruai.json` in the working directory and should contain the following:
```json
{
    "openai": {
        "api_key": "your-api-key",
    },
    "assistants": {
        "summary": "",
        "ocr": ""
    },
    "outputdir": "output/",
    "tables": {
        "documents": "boru_openai_documents",
        "pages": "boru_openai_pages",
        "assistants": "boru_openai_assistants"
    },
    "prompts": {
        "summary": {
            "prefix": "This is part of a larger document that I need to summarize. There are {TOTAL_PAGES} pages in the document. Do not provide a page by page summary, but rather a summary of the entire document.",
            "context": "Here is the summary of the previous {DONE_PAGES} pages:\n{SUMMARY}",
            "update": "Using the previous summary, please create an updated summary adding the attached page(s). Retain the previous summary and add/update the new information. Keep the summary brief enough to utilize in further prompts, while retaining important information.",
            "new": "Please write a summary of the attached page(s). Keep the summary brief enough to utilize in further prompts, while retaining important information."
        }
    },
    "dbconfig": {
        "use": false,
        "dbhost": "localhost",
        "dbport": 3306,
        "dbname": "",
        "dbuser": "",
        "dbpass": "",
        "dbtype": "mysql"
    }
}
```

### dbconfig
The dbconfig section is used to specify the database connection information. If the `use` key is set to true, the library will attempt to connect to the database specified by the other keys. The `dbtype` key is used to specify the type of database to connect to. Currently, only `mysql` is supported.

The library will automatically utilize Vtiger's database connection if it is available within the scope of the script. If it is not available, the library will attempt to connect to the database using the information provided in the configuration file.

### assistants
The assistants section is used to specify the assistant models that are available to the library. The key is the name of the assistant, and the value is the id of the assistant model in the OpenAI API.

### outputdir
The outputdir section is used to specify the directory where the library will save output files. The directory must exist and be writable by the script.

### tables
The tables section is used to specify the names of the tables that the library will use to store information. The tables are used to store documents, pages, and assistants. The keys are the names of the tables, and the values are the names of the tables in the database.

### prompts
The prompts section is used for tools such as the Summarizer. The keys are the names of the prompts, and the values are the prompt templates. The templates can contain placeholders that will be replaced by the library when the prompt is used. The placeholders are enclosed in curly braces and are case-sensitive.
