<?php
namespace boru\openai\api\endpoints;

use boru\openai\models\Assistant;
use boru\openai\OpenAI;
use Exception;

class Assistants {
    public static function create($parameters=[]) {
        //print_r($parameters);
        //exit();
        return new Assistant(OpenAI::request("post","assistants",$parameters));
    }
    public static function listAssistants() {
        return OpenAI::requestList("get","assistants",[],Assistant::class);
    }
    public static function getAssistant($id) {
        return new Assistant(OpenAI::request("get","assistants/".$id));
    }
    public static function update($id,$parameters=[]) {
        return new Assistant(OpenAI::request("post","assistants/".$id,$parameters));
    }
    public static function delete($id) {
        return OpenAI::request("delete","assistants/".$id);
    }

    /**
     * 
     * @param mixed $assistantName 
     * @return Assistant|false 
     * @throws Exception 
     */
    public static function byName($assistantName) {
        $assistants = static::listAssistants();
        foreach($assistants as $assistant) {
            if(strtolower($assistant->name()) == strtolower($assistantName)) {
                return $assistant;
            }
        }
        return false;
    }
}