<?php
namespace boru\openai\api\endpoints;

use boru\openai\api\responses\ApiBaseResponse;
use boru\openai\models\File;
use boru\openai\OpenAI;

class Files {
    public static function listFiles($parameters=[]) {
        return OpenAI::requestList("get","files",$parameters,File::class);
    }

    public static function upload($parameters=[]) {
        return OpenAI::upload("files",$parameters);
    }

    public static function delete($file_id) {
        return OpenAI::request("delete","files/".$file_id);
    }

    public static function get($file_id) {
        return OpenAI::request("get","files/".$file_id);
    }

    public static function content($file_id) {
        return OpenAI::rawRequest("get","files/".$file_id."/content");
    }
}