<?php
namespace boru\openai\api\endpoints;

use boru\openai\api\responses\ApiBaseResponse;
use boru\openai\models\Thread;
use boru\openai\models\Run;
use boru\openai\OpenAI;
use Exception;

class Threads {
    public static function create($parameters=[]) {
        return new Thread(OpenAI::request("post","threads",$parameters));
    }
    public static function getThread($id) {
        return new Thread(OpenAI::request("get","threads/".$id));
    }
    public static function update($id,$parameters=[]) {
        return new Thread(OpenAI::request("post","threads/".$id,$parameters));
    }
    /**
     * 
     * @param mixed $parameters 
     * @return Run|false
     * @throws Exception 
     */
    public static function run($parameters) {
        $obj = OpenAI::request("post","threads/runs",$parameters);
        if($obj) {
            $run = new Run($obj->asArray());
            return $run;
        } else {
            return false;
        }
    }
}