<?php
namespace boru\openai\embeddings\distance;

abstract class Distance {
    private $distanceLimit = 0;
    /**
     * Measure the distance between two vectors
     * 
     * @param array $vector1
     * @param array $vector2
     * @param bool $returnSimilarity
     * @return float
     */
    abstract public function measure(array $vector1, array $vector2, $returnSimilarity = false);

    protected function distanceLimit($distance = null) {
        if($distance !== null) {
            $this->distanceLimit = $distance;
        }
        return $this->distanceLimit;
    }
}