<?php
namespace boru\openai\embeddings\distance;

class Euclidean extends Distance {
    public function measure(array $vector1, array $vector2, $returnSimilarity = false) {

        if (count($vector1) !== count($vector2)) {
            throw new \InvalidArgumentException('Arrays must have the same length.');
        }

        $sumOfSquares = 0;
        // Calculate the sum of squared differences
        for ($i = 0; $i < count($vector1); $i++) {
            $sumOfSquares += pow($vector1[$i] - $vector2[$i], 2);
        }

        $distance = sqrt($sumOfSquares);

        return $distance;    
        
        return false;
    }
}