<?php
namespace boru\openai\models;

use boru\openai\api\responses\ApiBaseResponse;
use boru\openai\OpenAI;

abstract class Base implements \JsonSerializable {
    public function __construct($options=[]) {
        $this->setFromData($options);
    }

    public function setFromData($options=[]) {
        if($options instanceof ApiBaseResponse) {
            $options = $options->asArray();
        }
        if(!is_array($options) && !is_object($options)) {
            $options = json_decode($options);
        }
        if(is_object($options)) {
            $options = (array)$options;
        }
        if(!is_array($options)) {
            throw new \Exception("Invalid options passed to constructor");
        }
        foreach($options as $key=>$value) {
            if(method_exists($this,$key)) {
                $this->$key($value);
            } elseif(strpos($key,"_") !== false) {
                $parts = explode("_",$key);
                $start = array_shift($parts);
                $parts = array_map(function($part) {
                    return ucfirst($part);
                },$parts);
                $key = $start . implode("",$parts);
                if(method_exists($this,$key)) {
                    $this->$key($value);
                } elseif(method_exists($this,strtolower($key))) {
                    $strLowerKey = strtolower($key);
                    $this->$strLowerKey($value);
                }
            }
        }
    }

    public static function tableName($tableName=null) {
        return "";
    }

    public static function search($search=[],$limit=10,$offset=0) {
        $db = OpenAI::db();
        if(!$db) {
            return false;
        }
        $tableName = static::tableName();
        //search is in Column=>Value Format
        $where = [1];
        $params = [];
        foreach($search as $column=>$value) {
            $where[] = $column . "=?";
            $params[] = $value;
        }
        $where = implode(" AND ",$where);
        $sql = "SELECT * FROM $tableName WHERE $where LIMIT $offset,$limit";
        $result = $db->run($sql,$params);
        $results = [];
        while($row = $db->next($result)) {
            $results[] = new static($row->asArray());
        }
        return $results;
    }

    abstract public function toArray();

    public function __toString() {
        return json_encode($this->toArray());
    }

    public function jsonSerialize() {
        return $this->toArray();
    }
}