<?php
namespace boru\openai\models;

use boru\openai\api\endpoints\ChatCompletions;
use boru\openai\api\responses\ChatCompletionResponse;
use boru\openai\OpenAI;

class Chat extends Base {

    //private $model = "gpt-3.5-turbo";
    private $model = "gpt-4";

    /**
     * @var Messages
     * A list of messages to use as context for the completion. Each message should be an object with a role key and a content key. The role key should be either user or assistant, and the content key should be the text of the message.
     */
    private $messages;

    /**
     * @var float|null
     * What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.
     * We generally recommend altering this or top_p but not both.
     */
    private $temperature = null; // 1

    /**
     * @var float|null
     * An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.
     * We generally recommend altering this or temperature but not both.
     */
    private $top_p = null; // 1

    /**
     * @var int|null
     * The maximum number of tokens to generate. The default is 64, and the maximum is 2048.
     */
    private $max_tokens = null; // 100

    /**
     * @var int
     * The number of candidates to return. We generally recommend this to be 1, but it can be set to any integer value.
     */
    private $n = 1;

    /**
     * @var bool
     * Whether to stream back partial progress. This is useful for long-running requests, such as generating an entire article, where you want to see progress as it's being generated.
     */
    private $stream = false;

    /**
     * @var array
     * A list of tokens which will cause the API to stop generating further tokens. This is useful if you want to control the length of the output.
     */
    private $stop = [];

    /**
     * @var float
     * A floating-point value that penalizes new tokens based on whether they appear in the text so far. Increasing this value makes the model more likely to talk about new topics, and decreasing it makes the model more likely to repeat the same line verbatim.
     */
    private $presence_penalty = 0;

    /**
     * @var float
     * A floating-point value that penalizes new tokens based on their existing frequency in the text so far. Increasing this value makes the model more likely to talk about new topics, and decreasing it makes the model more likely to repeat the same line verbatim.
     */
    private $frequency_penalty = 0;

    public function __construct($input="gpt-3.5-turbo",$options=[]) {
        if(!is_array($input)) {
            $this->model = $input;
        } else {
            $options = $input;
        }
        $this->messages = new Messages();
        if(isset($options["messages"])) {
            foreach($options["messages"] as $msg) {
                $this->addMessage($msg["role"],$msg["content"],isset($msg["name"]) ? $msg["name"] : "");
            }
            unset($options["messages"]);
        }
        parent::__construct($options);
    }

    public function toArray($forSend=true) {
        $arr = [
            "model" => $this->model,
            "messages" => [],
        ];
        if(!is_null($this->temperature)) {
            $arr["temperature"] = $this->temperature;
        }
        if(!is_null($this->top_p)) {
            $arr["top_p"] = $this->top_p;
        }
        if(!is_null($this->max_tokens)) {
            $arr["max_tokens"] = $this->max_tokens;
        }
        $arr["n"] = $this->n;
        $arr["stream"] = $this->stream;
        if(!empty($this->stop)) {
            $arr["stop"] = $this->stop;
        }
        $arr["presence_penalty"] = $this->presence_penalty;
        $arr["frequency_penalty"] = $this->frequency_penalty;
        $arr["messages"] = $this->messages->toArray();
        return $arr;
    }

    /**
     * @param array $parameters
     * @return array|ChatCompletionResponse
     * @throws \Exception
     */
    public static function create($parameters,$returnAsArray=false) {
        if($returnAsArray) {
            return OpenAI::request("post","chat/completions",$parameters,$returnAsArray);
        } else {
            return ChatCompletions::create($parameters);
        }
    }

    /**
     * 
     * @return ChatCompletionResponse|string|false 
     * @param int|false $choice  the index of the choice to return, or false to return the full response
     * @param bool $contentOnly  whether to return the content only or the full response
     * @throws Exception 
     */
    public function run($choice=0,$contentOnly=true) {
        $parameters = $this->toArray(true);
        $completion = ChatCompletions::create($parameters);
        if($choice === false) {
            return $completion;
        }
        if($contentOnly) {
            $array = $completion->choice($choice);
            if(isset($array["message"]["content"])) {
                return $array["message"]["content"];
            }
            return $array;
        }
        return $completion->choice($choice);   
    }

    /**
     * Send the request to the API
     * @param   bool    $returnAsArray  Whether to return the response as an array or an ApiResponse object
     * @param   bool    $send           Whether to send the request or not, returns the parameters if false
     * @param   bool    $debug          Whether to print the request parameters or not
     * @return  array|ChatCompletionResponse|false
     */
    public function send($returnAsArray=false,$send=true,$debug=false) {
        $parameters["model"] = $this->model;
        if(!is_null($this->temperature)) {
            $parameters["temperature"] = $this->temperature;
        }
        if(!is_null($this->top_p)) {
            $parameters["top_p"] = $this->top_p;
        }
        if(!is_null($this->max_tokens)) {
            $parameters["max_tokens"] = $this->max_tokens;
        }
        $parameters["n"] = $this->n;
        $parameters["stream"] = $this->stream;
        if(!empty($this->stop)) {
            $parameters["stop"] = $this->stop;
        }
        $parameters["presence_penalty"] = $this->presence_penalty;
        $parameters["frequency_penalty"] = $this->frequency_penalty;
        $parameters["messages"] = $this->messages;
        if($debug) {
            print_r($parameters);
        }
        if($send) {
            return self::create($parameters,$returnAsArray);
        }
        return $parameters;
    }
    
    public function model($model=null) {
        if($model !== null) {
            $this->model = $model;
        }
        return $this->model;
    }
    public function temperature($temperature=null) {
        if($temperature !== null) {
            $this->temperature = $temperature;
        }
        return $this->temperature;
    }
    public function topP($top_p=null) {
        if($top_p !== null) {
            $this->top_p = $top_p;
        }
        return $this->top_p;
    }
    public function maxTokens($max_tokens=null) {
        if($max_tokens !== null) {
            $this->max_tokens = $max_tokens;
        }
        return $this->max_tokens;
    }
    public function n($n=null) {
        if($n !== null) {
            $this->n = $n;
        }
        return $this->n;
    }
    public function stream($stream=null) {
        if($stream !== null) {
            $this->stream = $stream;
        }
        return $this->stream;
    }
    public function stop($stop=null) {
        if($stop !== null) {
            $this->stop = $stop;
        }
        return $this->stop;
    }
    public function presencePenalty($presence_penalty=null) {
        if($presence_penalty !== null) {
            $this->presence_penalty = $presence_penalty;
        }
        return $this->presence_penalty;
    }
    public function frequencyPenalty($frequency_penalty=null) {
        if($frequency_penalty !== null) {
            $this->frequency_penalty = $frequency_penalty;
        }
        return $this->frequency_penalty;
    }

    /**
     * Set the model to use for the chat
     */ 
    public function setModel($model) { $this->model($model); }
    public function setTemperature($temperature) { $this->temperature($temperature); }
    public function setTopP($top_p) { $this->topP($top_p); }
    public function setMaxTokens($max_tokens) { $this->maxTokens($max_tokens); }
    public function setN($n) { $this->n($n); }
    public function setStream($stream) { $this->stream($stream); }
    public function setStop($stop) { $this->stop($stop); }
    public function setPresencePenalty($presence_penalty) { $this->presencePenalty($presence_penalty); }
    public function setFrequencyPenalty($frequency_penalty) { $this->frequencyPenalty($frequency_penalty); }

    public function addMessage($role,$content,$name="") {
        $msg = [
            "role" => $role,
            "content" => $content,
        ];
        if($name) {
            $msg["name"] = $name;
        }
        $this->messages->add($msg);
    }

    public function message($message) {
        if($this->messages === null) {
            $this->messages = new Messages();
        }
        $this->messages->add($message);
        return $this;
    }
    public function messages($messages=null) {
        if($messages !== null) {
            $this->messages = new Messages($messages);
        }
        return $this->messages;
    }

    public static function fromArray($options=[]) {
        $chat = new Chat($options);
        if(isset($options["messages"])) {
            foreach($options["messages"] as $msg) {
                $chat->addMessage($msg["role"],$msg["content"],isset($msg["name"]) ? $msg["name"] : "");
            }
        }
        return $chat;
    }
}