<?php
namespace boru\openai\models;

use boru\openai\api\endpoints\Files;
use boru\openai\api\endpoints\Uploads;
use boru\openai\OpenAI;
use boru\openai\tools\OCR;
use Exception;

class Upload extends Base {
    /** @var string */
    private $id;
    /** @var string */
    private $object = "upload";
    /** @var int */
    private $bytes;
    /** @var int */
    private $createdAt;
    /** @var string */
    private $filename;
    /** @var string */
    private $purpose;
    /** @var string */
    private $status;
    /** @var int */
    private $expiresAt;
    /** @var File */
    private $file;

    public function __construct($filenameOrArray=null) {
        if ($filenameOrArray !== null) {
            if (is_array($filenameOrArray)) {
                $this->loadFromArray($filenameOrArray);
            } else if (is_string($filenameOrArray)) {
                $this->filename = $filenameOrArray;
            }
        }
    }
    public function loadFromArray($array) {
        $this->id = $array["id"];
        $this->object = $array["object"];
        $this->bytes = $array["bytes"];
        $this->createdAt = $array["created_at"];
        $this->filename = $array["filename"];
        $this->purpose = $array["purpose"];
        $this->status = $array["status"];
        $this->expiresAt = $array["expires_at"];
        if (isset($array["file"])) {
            $this->file = new File($array["file"]);
        }
    }

    public function toArray() {
        $array = [];
        $array["id"] = $this->id;
        $array["object"] = $this->object;
        $array["bytes"] = $this->bytes;
        $array["created_at"] = $this->createdAt;
        $array["filename"] = $this->filename;
        $array["purpose"] = $this->purpose;
        $array["status"] = $this->status;
        $array["expires_at"] = $this->expiresAt;
        if ($this->file) {
            $array["file"] = $this->file->toArray();
        }
    }

    public function id($id=null) {
        if ($id) {
            $this->id = $id;
        }
        return $this->id;
    }
    public function object($object=null) {
        if ($object) {
            $this->object = $object;
        }
        return $this->object;
    }
    public function bytes($bytes=null) {
        if ($bytes) {
            $this->bytes = $bytes;
        }
        return $this->bytes;
    }
    public function createdAt($createdAt=null) {
        if ($createdAt) {
            $this->createdAt = $createdAt;
        }
        return $this->createdAt;
    }
    public function filename($filename=null) {
        if ($filename) {
            $this->filename = $filename;
        }
        return $this->filename;
    }
    public function purpose($purpose=null) {
        if ($purpose) {
            $this->purpose = $purpose;
        }
        return $this->purpose;
    }
    public function status($status=null) {
        if ($status) {
            $this->status = $status;
        }
        return $this->status;
    }
    public function expiresAt($expiresAt=null) {
        if ($expiresAt) {
            $this->expiresAt = $expiresAt;
        }
        return $this->expiresAt;
    }
    public function file($file=null) {
        if ($file) {
            $this->file = $file;
        }
        return $this->file;
    }

    public function upload($filename=null,$mime=null) {
        if($filename === null) {
            if($this->filename === null) {
                throw new Exception("Filename is required to upload a file");
            }
            $filename = $this->filename;
        }
        if(!file_exists($filename)) {
            throw new Exception("File not found: ".$filename);
        }
        if($mime === null) {
            $mime = mime_content_type($filename);
        }
        //create the upload
        $response = Uploads::create([
            "purpose" => $this->purpose,
            //just the filename, not the full path
            "filename" => basename($filename),
            "bytes" => filesize($filename),
            "mime_type" => $mime
        ]);

        $this->loadFromArray($response->asArray());

        $parts = [];

        //may need to chunk the file here.. but for now we'll just do a single part upload
        $parameters = [
            "data"=>fopen($filename,"r")
        ];
        $response = Uploads::addPart($this->id, $parameters);
        //$body = $response->asArray();
        $parts[] = $response->get("id");

        //complete upload
        $response = Uploads::complete($this->id,["part_ids"=>$parts]);
        $this->loadFromArray($response->asArray());
        return $this;
    }
}

/*
{
  "id": "upload_abc123",
  "object": "upload",
  "bytes": 2147483648,
  "created_at": 1719184911,
  "filename": "training_examples.jsonl",
  "purpose": "fine-tune",
  "status": "completed",
  "expires_at": 1719127296,
  "file": {
    "id": "file-xyz321",
    "object": "file",
    "bytes": 2147483648,
    "created_at": 1719186911,
    "filename": "training_examples.jsonl",
    "purpose": "fine-tune",
  }
}
*/