<?php
namespace boru\openai\tools;

use boru\dhutils\dhGlobal;

class Template {
    protected $templateFormat;

    public function __construct($templateFormat=null) {
        if(!is_null($templateFormat)) {
            $this->setTemplateFormat($templateFormat);
        }
    }
    public function setTemplateFormat($templateFormat) {
        $this->templateFormat = $templateFormat;
    }

    /**
     * Parse an array into a template
     * @param array $array
     * @return string
     */
    public function parse($array) {
        $template = $this->templateFormat;
        foreach($array as $key => $value) {
            $template = str_replace("{{" . $key . "}}",$value,$template);
        }
        return $template;
    }

    /**
     * Parse an array of arrays into a template
     * @param array $array
     * @param string $split
     * @return string
     */
    public function multiParse($array,$split="\n") {
        $string = "";
        foreach($array as $arr) {
            if($string != "") {
                $string .= $split;
            }
            $string .= $this->parse($arr);
        }
        return $string;
    }

    public static function fromFile($filePath) {
        if(!is_object($filePath)) {
            if(($template = dhGlobal::fileIfExists($filePath)) === false) {
                throw new \Exception("Template file not found: " . $filePath);
            }
            return new Template($template->content());
        } elseif($filePath instanceof \boru\dhutils\filesys\File) {
            return new Template($filePath->content());
        } else {
            throw new \Exception("Invalid file path");
        }
    }
}