<?php

use boru\openai\embeddings\Document;
use boru\openai\embeddings\vectorstore\FileVectorStore;
use boru\output\Output;

require __DIR__.'/../init.php';

if(php_sapi_name() != "cli") {
    Output::outLine("This script is intended to be run from the command line");
    exit(1);
}
array_shift($argv);

$file = $number = false;

if(!empty($argv)) {
    $number = array_shift($argv);
}
if(!empty($argv)) {
    $file = array_shift($argv);
}
if($number === false) {
    Output::outLine("Usage: php generate.php <number> [file]");
    exit(1);
}
if($file === false) {
    $file = __DIR__.'/store.json';
}
$number = intval($number);
Output::outLine("Generating $number test documents");
$documents = Document::generateTestDocuments($number);
Output::outLine("We have ".count($documents)." documents");
Output::outLine("Adding them to the vector store at $file");
$vectorStore = new FileVectorStore($file);
$vectorStore->addDocuments($documents);
Output::outLine("Done");