<?php

use boru\openai\embeddings\Document;
use boru\openai\embeddings\vectorstore\FileVectorStore;
use boru\output\Output;

require __DIR__.'/../init.php';

if(php_sapi_name() != "cli") {
    Output::outLine("This script is intended to be run from the command line");
    exit(1);
}
array_shift($argv);

$file = $number = false;
if(!empty($argv)) {
    $number = array_shift($argv);
}
if(!empty($argv)) {
    $file = array_shift($argv);
}
if($number === false) {
    $number = 0;
}
if($file === false) {
    $file = __DIR__.'/store.json';
}
$vectorStore = new FileVectorStore($file);
if($vectorStore->countDocuments() <= 0) {
    Output::outLine("Vector store is empty");
    exit(1);
}
Output::outLine("Vector store has",$vectorStore->countDocuments(),"documents");
$i=0;
foreach($vectorStore->getDocuments() as $document) {
    if($number > 0 && $i >= $number) {
        break;
    }
    Output::outLine("#",$i,"\t",$document->content());
    $i++;
}
