# openai

This library helps interface with the OpenAI API. The purpose is to make it easier to interact with the API and to provide a more PHP-like interface.

## Installation
Requires the Boru Satis repository to be added to your composer.json file. This can be done by adding the following to your composer.json file:
```json
{
    "repositories": [
        {
            "type": "composer",
            "url":  "https://satis.boruapps.com"
        }
    ]
}
```

Then you can install the package using composer:
```bash
composer require boru/openai
```

## Configuration
### [See the Configuration instructions here](docs/configuration.md)

## Usage

To use the library, you must first initialize it. This can be done in one of three ways:
```php
use Boru\OpenAI\OpenAI;

//pick one:

//Utilizing the default configuration file "config_boruai.json" in the working directory
OpenAI::init();

//Utilizing a custom API key and the default configuration file "config_boruai.json" in the working directory
OpenAI::init($apiKey);

//Utilizing a custom API key and a custom configuration file
OpenAI::init($apiKey, $configFileLocation);
```

### [See the Full Documentation here](docs/README.md)
