<?php
namespace boru\openai\api\endpoints;

use boru\openai\models\Message;
use boru\openai\OpenAI;

class Messages {
    public static function create($threadId,$parameters=[]) {
        return new Message(OpenAI::request("post","threads/".$threadId."/messages",$parameters));
    }
    public static function listMessages($threadId) {
        return OpenAI::requestList("get","threads/".$threadId."/messages",[],Message::class);
        //return OpenAI::request("get","threads/".$threadId."/messages");
    }
    public static function getMessage($threadId,$messageId) {
        return new Message(OpenAI::request("get","threads/".$threadId."/messages/".$messageId));
    }
    public static function update($threadId,$messageId,$parameters=[]) {
        return new Message(OpenAI::request("post","threads/".$threadId."/messages/".$messageId,$parameters));
    }
    
}