<?php
namespace boru\openai\cli;

use boru\cli\CLIInterface;
use boru\cli\params\Option;
use boru\output\Output;
use boru\openai\cli\defs\AssistantCLI;
use boru\openai\cli\defs\FileCLI;
use boru\openai\cli\defs\ModelCLI;
use boru\openai\cli\defs\PromptCLI;
use boru\openai\OpenAI;

class OpenAICLI extends CLIInterface {

    public static function CLI_def() {
        return [
            "name"=> "Boru AI CLI",
            "description"=> "A command line interface for the Boru AI API",
            "params" => [
                Option::create("c|config|The configuration file to use"),
            ]
        ];
    }
    public function __construct($command) {
        parent::__construct($command);
        $config = $this->get("config",false);
        
        try {
            if($config) {
                OpenAI::initConfig($config);
            } else {
                OpenAI::init();
            }
            Output::init(["prefix"=>false]);
        } catch(\Exception $e) {
            Output::outLine("Error: " . $e->getMessage());
            exit();
        }
    }

    use AssistantCLI;
    use ModelCLI;
    use PromptCLI;
    use FileCLI;

    
}