<?php
namespace boru\openai\cli\defs;

use boru\cli\CLI;
use boru\cli\params\Flag;
use boru\cli\params\Option;
use boru\cli\params\Positional;
use boru\dhutils\dhGlobal;
use boru\output\Output;
use boru\openai\api\endpoints\Assistants;
use boru\openai\api\endpoints\Files;
use boru\openai\models\Assistant;
use boru\openai\models\File;
use boru\openai\models\Prompt;

trait FileCLI {
    public function def_file() {
        return [
            "description"=> "File Operations",
        ];
    }

    public function def_file_list() {
        return [
            "description"=> "List Files",
        ];
    }
    public function cmd_file_list($cmd) {
        $files = Files::listFiles();
        foreach(Files::listFiles() as $file) {
            Output::outLine($file->id()."\t".$file->filename());
        }
    }

    public function def_file_get() {
        return [
            "description"=> "Get File",
            "params" => [
                Positional::create("fileid|File ID"),
                Flag::create("d|data|Return the file content instead of the file object"),
                Flag::create("f|force|Force overwrite of the output file"),
                Option::create("o|output|The name of the file to write the file data to"),
            ]
        ];
    }
    public function cmd_file_get() {
        $fileId = $this->get("fileid");
        try {
            $file = File::fromId($fileId);
            if(!$file) {
                Output::outLine("File not found");
                return;
            }
        } catch(\Exception $e) {
            Output::outLine("Error: File not found or API error");
            return;
        }

        if($this->get("data")) {
            $data = $file->content();
            if($this->get("output")) {
                if(file_exists($this->get("output")) && !$this->get("force")) {
                    Output::outLine("Output file exists. Use -f to force overwrite");
                    return;
                }
                if(is_dir($this->get("output"))) {
                    Output::outLine("Output file is a directory");
                    return;
                }
                file_put_contents($this->get("output"),$data);
                Output::outLine("File written to",$this->get("output"));
            } else {
                Output::outLine($data);
            }
        } else {
            Output::outLine($file->id());
            Output::outLine(json_encode($file->toArray(),JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE));
        }
    }

    public function def_file_delete() {
        return [
            "description"=> "Delete File",
            "params" => [
                Positional::create("fileid|File ID"),
                Flag::create("f|force|Delete without confirmation"),
            ]
        ];
    }
    public function cmd_file_delete() {
        $fileId = $this->get("fileid");
        try {
            $file = File::fromId($fileId);
            if(!$file) {
                Output::outLine("File not found");
                return;
            }
        } catch(\Exception $e) {
            Output::outLine("Error: File not found or API error");
            return;
        }
        if(!$this->get("force")) {
            $confirm = CLI::promptChoice("Are you sure".$file->id()."?",["y","n"]);
            if(strtolower($confirm) != "y") {
                Output::outLine("Cancelled");
                return;
            }
        }
        $file->delete();
        Output::outLine("File",$file->id(),"deleted");
    }
}