<?php
namespace boru\openai\cli\defs;

use boru\openai\api\endpoints\Models;
use boru\cli\params\Option;
use boru\cli\params\Positional;
use boru\output\Output;

trait ModelCLI {
    public function def_model() {
        return [
            "description"=> "Model Operations",
            "params" => []
        ];
    }

    public function def_model_list() {
        return [
            "description"=> "List Models",
            "params"=> []
        ];
    }
    public function cmd_model_list($cmd) {
        $models = Models::listModels();
        foreach($models as $model) {
            Output::outLine($model->id());
        }
    }

    public function def_model_get() {
        return [
            "description"=> "Get Model",
            "params" => [
                Positional::create("model|Model ID"),
            ]
        ];
    }
    public function cmd_model_get($cmd) {
        $model_id = $this->get("model");
        $model = Models::getModel($model_id);
        if($model) {
            $data=json_encode($model->asArray(),JSON_PRETTY_PRINT);
            Output::outLine($data);
        }
    }
}