<?php
namespace boru\openai\cli\defs;

use boru\cli\params\Flag;
use boru\cli\params\Option;
use boru\cli\params\Positional;
use boru\dhutils\dhGlobal;
use boru\output\Output;
use boru\openai\api\endpoints\Assistants;
use boru\openai\models\Assistant;
use boru\openai\models\Prompt;

trait PromptCLI {
    public function def_prompt() {
        return [
            "description"=> "Prompt Operations",
            "params" => [
                Positional::create("assistant|Assistant to manage prompts for"),
            ]
        ];
    }

    public function cmd_prompt_list($cmd) {
        $search = [];
        if($this->get("assistant",false)) {
            $search["assistant_id"] = $this->get("assistant");
        }
        $prompts = Prompt::search($search);

        foreach($prompts as $prompt) {
            $assistant = Assistant::fromTable($prompt->assistantId());
            if(!$assistant) {
                try {
                    $assistant = Assistants::getAssistant($prompt->assistantId());
                    $assistant->saveToTable();
                } catch(\Exception $e) {
                    $assistant = new Assistant();
                    $assistant->id($prompt->assistantId());
                    $assistant->name("Unknown");
                }
            }
            Output::outLine($prompt->id(),"\t",$prompt->assistantId(),"\t",$assistant->name(),"\t",$prompt->name());
        }
    }

    public function def_prompt_get() {
        return [
            "description"=> "Get Prompt",
            "params" => [
                Positional::create("prompt|Prompt ID or name"),
            ]
        ];
    }
    public function cmd_prompt_get() {
        $promptId = $this->get("prompt");
        if($this->get("assistant",false)) {
            $prompt = Prompt::forAssistant($this->get("assistant"),$promptId);
        } else {
            $prompt = Prompt::queryById($promptId);
            if(!$prompt) {
                $prompt = Prompt::queryByName($promptId);
            }
        }
        if($prompt) {
            Output::outLine($prompt->prompt());
        } else {
            Output::outLine("Prompt not found");
        }
    }
    public function def_prompt_list() {
        return [
            "description"=> "List Prompts",
        ];
    }
}