<?php

namespace boru\openai\command;

use boru\dhcli\Option;
use boru\openai\api\endpoints\Models;
use boru\openai\tools\PDFConverter;

class PdfCommand extends BaseCommand {
    public static $commandName = "pdf";
    public static $commandDescription = "PDF file actions";
    public static function setCommandOptions() {
        return [
            Option::positional("command","The command to execute",true,["options"=>["upload","convert","summary"]]),
            Option::positional("file","The PDF file",true),
            Option::option("d","dir","The output directory for page images",false),
            Option::option("a","assistant","The assistant to use for summarizing",false),
            //Option::option("o","output","The output file for the summary, STDOUT if ommitted",false),
        ];
    }

    private $outputDir;

    public function __construct($result) {
        parent::__construct($result);

        $this->outputDir = $this->get("dir",__DIR__.'/../../output/');

        $command = $this->get("command","convert");
        switch ($command) {
            case "convert":
                $this->convertCommand();
                break;
            case "upload":
                $this->uploadCommand();
                break;
            default:
                $this->error("Invalid command: $command");
        }
    }

    public function convertCommand() {
        $pdfFile = $this->get("file");
        $converter = new PDFConverter($pdfFile,$this->outputDir);
        $outputFiles = $converter->convert();
    }

    public function uploadCommand() {
        $pdfFile = $this->get("file");
        $converter = new PDFConverter($pdfFile,$this->outputDir);
        $outputFiles = $converter->convert();
        $fileIds = $converter->upload();
        foreach($fileIds as $fileId) {
            $this->output($fileId);
        }
    }

    public function listCommand() {
        $models = Models::listModels();
        foreach($models as $model) {
            $this->output($model->id());
        }
    }
}