<?php
namespace boru\openai\embeddings\vectorstore;

use boru\openai\embeddings\Document;
use boru\openai\models\Chat;

abstract class VectorStore {
    abstract public function addDocument(Document $document);
    abstract public function addDocuments(array $documents);
    abstract public function similarity($embedding, $k = 4, $extraArgs = []);

    protected function embedDocument(Document $document,$force=false) {
        $document->embed($force);
    }


    public static function generateTestDocuments($num=100) {
        return Document::generateTestDocuments($num);
    }
}